/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.traccar.session.ConnectionKey;

public class LogRecord {
    private final InetSocketAddress localAddress;
    private final InetSocketAddress remoteAddress;
    private String protocol;
    private String uniqueId;
    private long deviceId;
    private String data;

    public LogRecord(SocketAddress localAddress, SocketAddress remoteAddress) {
        this.localAddress = (InetSocketAddress)localAddress;
        this.remoteAddress = (InetSocketAddress)remoteAddress;
    }

    @JsonIgnore
    public InetSocketAddress getAddress() {
        return this.remoteAddress;
    }

    @JsonIgnore
    public ConnectionKey getConnectionKey() {
        return new ConnectionKey(this.localAddress, (SocketAddress)this.remoteAddress);
    }

    public String getHost() {
        return this.remoteAddress.getHostString();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

