/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;
import org.traccar.helper.BufferUtil;

public class ArnaviFrameDecoder
extends BaseFrameDecoder {
    private static final int HEADER_LENGTH = 10;
    private static final int PACKET_WRAPPER_LENGTH = 8;
    private static final int RESULT_TYPE = 253;
    private static final byte PACKAGE_END_SIGN = 93;
    private boolean firstPacket = true;

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 4) {
            return null;
        }
        if (buf.getByte(buf.readerIndex()) == 36) {
            int index = BufferUtil.indexOf("\r\n", buf);
            if (index > 0) {
                ByteBuf frame = buf.readRetainedSlice(index - buf.readerIndex());
                buf.skipBytes(2);
                return frame;
            }
        } else {
            int length;
            if (this.firstPacket) {
                this.firstPacket = false;
                length = 10;
            } else {
                short type = buf.getUnsignedByte(1);
                if (type == 253) {
                    length = 4;
                } else {
                    int index = 2;
                    while (index + 8 < buf.readableBytes() && buf.getByte(index) != 93) {
                        index += 8 + buf.getUnsignedShortLE(index + 1);
                    }
                    if (buf.getByte(index) != 93) {
                        return null;
                    }
                    length = index + 1;
                }
            }
            if (buf.readableBytes() >= length) {
                return buf.readRetainedSlice(length);
            }
        }
        return null;
    }
}

