/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.host;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.graalvm.visualvm.host.HostsSupport;
import org.graalvm.visualvm.host.RemoteHostsContainer;
import org.graalvm.visualvm.host.impl.HostCustomizer;
import org.graalvm.visualvm.host.impl.HostProperties;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class AddRemoteHostAction
extends SingleDataSourceAction<RemoteHostsContainer> {
    private static final String ICON_PATH = "org/graalvm/visualvm/host/resources/addRemoteHost.png";
    private static final Image ICON = ImageUtilities.loadImage((String)"org/graalvm/visualvm/host/resources/addRemoteHost.png");
    private boolean tracksSelection = false;
    private static AddRemoteHostAction alwaysEnabled;
    private static AddRemoteHostAction selectionAware;

    public static synchronized AddRemoteHostAction alwaysEnabled() {
        if (alwaysEnabled == null) {
            alwaysEnabled = new AddRemoteHostAction();
            alwaysEnabled.putValue("SmallIcon", new ImageIcon(ICON));
            alwaysEnabled.putValue("iconBase", ICON_PATH);
        }
        return alwaysEnabled;
    }

    public static synchronized AddRemoteHostAction selectionAware() {
        if (selectionAware == null) {
            selectionAware = new AddRemoteHostAction();
            AddRemoteHostAction.selectionAware.tracksSelection = true;
        }
        return selectionAware;
    }

    protected void actionPerformed(RemoteHostsContainer remoteHostsContainer, ActionEvent actionEvent) {
        final HostProperties hostDescriptor = HostCustomizer.defineHost();
        if (hostDescriptor != null) {
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    HostsSupport.getInstance().createHost(hostDescriptor, true, true);
                }
            });
        }
    }

    protected boolean isEnabled(RemoteHostsContainer remoteHostsContainer) {
        return true;
    }

    protected void updateState(Set<RemoteHostsContainer> remoteHostsContainerSet) {
        if (this.tracksSelection) {
            super.updateState(remoteHostsContainerSet);
        }
    }

    private AddRemoteHostAction() {
        super(RemoteHostsContainer.class);
        this.putValue("Name", NbBundle.getMessage(AddRemoteHostAction.class, (String)"LBL_Add_Remote_Host"));
        this.putValue("ShortDescription", NbBundle.getMessage(AddRemoteHostAction.class, (String)"ToolTip_Add_Remote_Host"));
    }
}

