/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScanTask;
import org.zaproxy.zap.extension.pscan.PassiveScanTaskHelper;
import org.zaproxy.zap.utils.Stats;
import org.zaproxy.zap.view.ScanStatus;

@Deprecated(forRemoval=true, since="2.16.0")
public class PassiveScanController
extends Thread
implements ProxyListener {
    private static final Logger LOGGER = LogManager.getLogger(PassiveScanController.class);
    private ExtensionHistory extHist;
    private PassiveScanTaskHelper helper;
    private Session session;
    private ThreadPoolExecutor executor;
    private int currentId = 1;
    private int lastId = -1;
    private int mainSleep = 2000;
    private int postSleep = 200;
    private volatile boolean shutDown = false;

    public PassiveScanController(ExtensionPassiveScan extPscan, ExtensionHistory extHistory, ExtensionAlert extAlert, PassiveScanParam passiveScanParam, ScanStatus scanStatus) {
        this.setName("ZAP-PassiveScanController");
        this.extHist = extHistory;
        this.helper = new PassiveScanTaskHelper(extPscan, extAlert, null);
        this.lastId = this.currentId = this.getLastHistoryId();
    }

    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void run() {
        LOGGER.debug("Starting passive scan monitoring");
        try {
            this.scan();
        }
        finally {
            LOGGER.debug("Stopping passive scan monitoring");
        }
    }

    private void scan() {
        this.lastId = this.currentId = this.getLastHistoryId();
        HistoryReference href = null;
        while (!this.shutDown) {
            try {
                if (href != null || this.lastId > this.currentId) {
                    ++this.currentId;
                } else {
                    try {
                        Thread.sleep(this.mainSleep);
                        if (this.shutDown) {
                            return;
                        }
                    }
                    catch (InterruptedException e) {
                        try {
                            Thread.sleep(this.postSleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.lastId = this.getLastHistoryId();
                }
                href = this.getHistoryReference(this.currentId);
                if (this.shutDown) {
                    return;
                }
                if (href != null && (!this.getPassiveScanParam().isScanOnlyInScope() || this.session.isInScope(href))) {
                    LOGGER.debug("Submitting request to executor: {} id {} type {}", (Object)href.getURI(), (Object)this.currentId, (Object)href.getHistoryType());
                    this.getExecutor().submit(new PassiveScanTask(href, this.helper));
                }
                int recordsToScan = this.getRecordsToScan();
                Stats.setHighwaterMark("stats.pscan.recordsToScan", recordsToScan);
            }
            catch (Exception e) {
                if (this.shutDown) {
                    return;
                }
                if (href != null && HistoryReference.getTemporaryTypes().contains(href.getHistoryType())) {
                    LOGGER.debug("Temporary record {} no longer available:", (Object)this.currentId, (Object)e);
                    continue;
                }
                LOGGER.error("Failed on record {} from History table", (Object)this.currentId, (Object)e);
            }
        }
    }

    private PassiveScanParam getPassiveScanParam() {
        return this.extHist.getModel().getOptionsParam().getParamSet(PassiveScanParam.class);
    }

    private ThreadPoolExecutor getExecutor() {
        if (this.executor == null || this.executor.isShutdown()) {
            int threads = this.getPassiveScanParam().getPassiveScanThreads();
            LOGGER.debug("Creating new executor with {} threads", (Object)threads);
            this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(threads, new PassiveScanThreadFactory("ZAP-PassiveScan-"));
        }
        return this.executor;
    }

    private HistoryReference getHistoryReference(int historyReferenceId) {
        if (this.extHist != null) {
            return this.extHist.getHistoryReference(historyReferenceId);
        }
        try {
            return new HistoryReference(historyReferenceId);
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            return null;
        }
    }

    private int getLastHistoryId() {
        return this.extHist.getLastHistoryId();
    }

    protected int getRecordsToScan() {
        return this.getLastHistoryId() - this.getLastScannedId() + this.helper.getRunningTasks().size();
    }

    private int getLastScannedId() {
        if (this.currentId > this.lastId) {
            return this.currentId - 1;
        }
        return this.currentId;
    }

    protected void shutdown() {
        LOGGER.debug("Shutdown");
        this.shutDown = true;
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.helper.shutdownTasks();
    }

    public List<PassiveScanTask> getRunningTasks() {
        return this.helper.getRunningTasks();
    }

    public PassiveScanTask getOldestRunningTask() {
        return this.helper.getOldestRunningTask();
    }

    public void clearQueue() {
        this.lastId = this.currentId = this.getLastHistoryId();
        this.helper.shutdownTasks();
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 5001;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage msg) {
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage msg) {
        this.interrupt();
        return true;
    }

    private static class PassiveScanThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final ThreadGroup group;

        public PassiveScanThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            this.group = Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 4) {
                t.setPriority(4);
            }
            return t;
        }
    }
}

