/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map 'United Kingdom'

* @author Vincent Brout
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :{
				united_kingdom : {
					width : 819.18506,
					height : 1239.183,
					getCoords : function (lat, lon) {
							var xfactor = 66.859448835909
								, xoffset = 700.45654250395
								, x = (lon * xfactor) + xoffset
								, yfactor = -113.75590782327
								, yoffset = 6921.9371320376
								, y = (lat * yfactor) + yoffset;
							
						return {'x' : x, 'y' : y};
					},
					elems : {
						"irl" : "m 209.53,622.66 c -0.12,0.02 -0.22,0.09 -0.34,0.13 -0.13,1.3 -0.53,3.04 0.34,4.19 0.86,0.33 0.22,1.7 1.19,1.88 1.29,0.76 2.52,1.88 3.97,2.31 0.36,0.48 1.01,1.35 0.66,1.88 -1.53,0.65 -3.19,0.34 -4.63,-0.34 -0.73,-0.25 -2.73,-0.01 -2.03,-1.28 0.93,0.09 1.95,-0.94 1.06,-1.75 -0.67,-0.96 -2.34,-0.94 -2.5,0.41 -0.16,0.88 -0.61,1.9 -1.69,1.63 -1.06,-0.18 -1.72,0.64 -2.25,1.38 -0.8,0.46 -1.16,-1.09 -2.03,-0.5 -1.17,0.9 -2.39,-0.83 -3.53,-0.19 -0.52,0.82 0.93,1.49 0.44,2.47 -0.47,1.06 -0.64,2.22 -0.88,3.34 -1.28,1.24 -1.93,3.53 -0.41,4.88 1.28,0.97 1.66,2.71 2.91,3.69 0.41,0.82 0.85,1.71 1.53,2.28 0.04,0.98 0.89,2 -0.06,2.84 -0.59,0.86 -1.52,2.04 -0.44,2.94 1.07,1.26 1.76,3.06 1.56,4.69 -0.78,0.77 -1.82,0.78 -2.81,0.81 -0.94,0.11 -1.95,0.67 -1.91,1.72 -0.31,1.09 -1.52,0.6 -2.16,1.31 -2.13,1.49 -3.59,3.66 -5.13,5.63 -1.19,-0.04 -2.22,0.85 -3.38,1.06 -0.08,0.35 -0.77,1.08 -1.03,0.53 -0.22,-0.88 0.37,-1.89 1.31,-1.91 0.71,-0.64 0.62,-1.78 1.41,-2.41 0.2,-0.79 0.55,-1.45 1.38,-1.75 1.59,-1.13 3.45,-2.3 4.28,-4.13 0.19,-1.23 -1.3,-1.31 -1.97,-0.63 -0.91,0.49 -2,0.31 -2.88,0.84 -0.98,0.06 -0.2,-1.43 0.16,-1.78 0.6,-0.84 2.26,-0.54 2.16,-1.91 0.8,-1.8 2.97,-2.21 4.34,-3.34 0.46,-0.7 -0.37,-1.68 0.53,-2.19 0.9,-1.9 -1.47,-3.11 -2.31,-4.5 -0.77,-0.78 -1.02,-1.83 -1.44,-2.75 -0.73,-0.5 -1.88,-0.27 -2.28,-1.28 -0.72,-0.7 -0.68,-1.82 0.13,-2.44 0.7,-0.79 0.54,-1.86 -0.03,-2.63 -0.35,-1.43 -0.59,-3.4 -2.06,-4.06 -1.52,0.23 -2.42,1.65 -3.28,2.75 -1.05,0.86 -2.39,10e-4 -3.5,0.31 -0.44,0.49 0.06,1.26 -0.72,1.63 -0.62,0.94 -1.98,1.12 -2.41,2.13 -0.01,0.96 1.36,0.73 1.38,1.72 0.47,0.86 1.19,0.08 1.75,-0.06 1.44,0.35 2.01,-0.69 1.5,-1.97 -0.17,-0.78 0.68,-2.12 1.5,-1.34 0.74,1.03 0.31,2.61 0.75,3.81 0.06,1.11 1.18,1.69 1.16,2.81 0.41,0.74 1.16,1.35 0.72,2.31 -0.4,1.9 -1.47,3.63 -1.53,5.59 -0.43,0.45 -2.17,0.52 -1.75,-0.47 0.35,-1.8 1.44,-3.89 0.59,-5.66 -0.55,-0.57 -0.87,-1.59 -1.84,-1.53 -0.59,-0.76 -1.8,-0.57 -2.38,-1.41 -0.95,-0.24 -1.87,0.5 -2.84,0.47 -1.67,0.71 -1.4,3.12 -2.84,4 -0.57,0.54 0.69,1.23 -0.19,1.53 -0.49,0.39 -1.26,0.42 -1.31,-0.34 -0.56,-0.8 -1.8,0.14 -2.31,-0.31 -0.18,-0.91 1.73,-1.81 0.44,-2.38 -0.44,0.17 -1.79,-0.17 -0.78,-0.63 1.16,-0.5 0.91,-2.52 -0.34,-2.56 -0.5,0.35 -1.01,0.92 -1.66,0.41 -0.86,-0.63 -2.9,-0.62 -2.72,0.75 -1.87,0.49 -4.2,-0.35 -5.72,1.22 -1.13,0.63 -3.25,0.24 -3.34,2 0.16,1.44 -1.58,2.42 -2.81,2.41 -1.04,-0.42 0.08,-1.78 -1.03,-2.19 -1.74,-0.63 -3.64,-0.42 -5.38,-1.09 -1.29,-0.42 -2.53,0.59 -2.5,1.91 0.39,1.59 -1.88,2.37 -1.22,3.94 0.15,0.74 1.31,1.22 1.25,1.88 -0.58,0.35 -1.63,0.63 -1.16,1.56 0.56,0.79 -0.73,1.72 0.22,2.44 0.37,0.31 0.75,0.82 0.03,0.97 -1.01,0.28 -0.89,1.28 -0.88,2.06 -0.35,0.5 -1.4,0.42 -1.19,-0.44 0.04,-1.1 -1.29,-1.8 -2.06,-0.88 -0.5,0.52 -1.53,0.4 -1.59,1.38 -0.39,0.5 -0.84,1.01 -0.53,1.75 0.25,0.52 -0.02,1.09 -0.63,0.78 -0.73,-0.25 -2.58,-1 -2.31,0.41 0.96,1.85 2.07,4.11 4.41,4.41 0.71,0.03 1.67,0.66 0.81,1.28 -0.7,0.78 -1.86,0.45 -2.63,1.06 -1.09,-0.14 -1.74,0.81 -2.69,1.06 -1.18,0.72 -0.06,2.12 0.94,2.31 0.97,0.14 1.63,1.16 2.56,1.16 0.64,-0.29 0.04,-1.46 1.06,-1.28 0.68,0.14 1.53,0.13 1.94,-0.41 0.99,0.2 0.46,2.52 1.88,2.13 0.53,-0.66 1.63,0.68 0.78,0.97 -0.55,0.45 -0.78,1.46 -1.69,1 -0.67,-0.27 -1.35,-0.66 -2.09,-0.16 -1.03,0.16 -1.81,1.8 -0.5,2.16 0.83,-0.05 1.68,0.31 1.84,1.16 1.36,0.59 2.58,-0.97 3.66,-1.59 0.48,-0.27 1.44,-1.16 1.88,-0.94 -0.3,1.75 -2.21,2.02 -3.38,3.03 -1.41,1.2 -3.78,1.8 -5.25,0.38 -1.1,-0.77 -2.53,-0.83 -3.56,0.06 -1.31,0.97 -2.54,-1.65 -3.78,-0.31 -0.17,0.6 0.02,1.53 -0.88,1.66 -0.89,0.21 -0.6,1.22 0.16,1.31 0.98,0.75 1.82,1.91 3.22,1.75 1.09,0.72 1.46,2.64 3.06,2.56 0.72,0.37 -0.34,1.44 -0.56,1.88 -1.04,1.79 -3.25,0.5 -4.81,0.41 -0.92,0.08 -1.74,-0.13 -2.44,-0.69 -1.32,-0.12 -2.3,-1.33 -3.72,-1.19 -1.74,0.1 -3.66,0.41 -5.13,1.38 -0.64,0.72 -2.16,0.74 -2.13,2 -0.9,0.61 -2.36,0.57 -2.78,1.81 -0.58,0.76 0.58,1.61 0.16,2.25 -0.94,0.67 -2.66,0.36 -3.09,1.5 0.43,1.31 -0.05,2.98 1.34,3.81 1.14,0.82 2.52,1.12 3.81,1.72 1.24,0.18 2.04,1.31 2.47,2.38 0.96,0.76 2.22,-0.54 1.59,-1.56 -0.21,-0.16 -0.35,-1.63 0.19,-1.22 0.79,0.98 0.94,2.98 2.66,2.66 0.28,0.45 0.79,1.2 1.56,1.16 0.84,0.02 1.49,-0.57 2.38,-0.5 1.59,-0.26 2.84,-2.03 4.5,-1.78 0.55,0.86 -0.69,2.39 0.53,2.81 1.14,-0.37 1.06,-1.83 1.28,-2.72 0.86,-0.28 0.75,-1.67 1.84,-1.47 0.08,0.71 0.11,1.9 1.19,1.63 0.61,-0.15 1.37,-0.35 1.44,0.53 0.23,0.63 0.48,2.35 1.47,1.44 0.44,-1.07 1.24,-1.83 2.38,-2.09 1,-0.3 1.82,-1.44 2.84,-1.47 0.99,0.72 0.9,2.07 0.06,2.88 -0.75,0.73 0.14,1.96 1,1.25 0.84,-0.71 2.02,-0.8 2.72,-1.75 1.32,-0.29 2,-1.58 3.22,-2 0.66,-1.07 2.39,0.39 2.78,-0.97 0.69,-0.27 1.92,-0.01 1.41,0.97 -0.22,0.97 0.75,1.47 0.63,2.44 0.5,0.75 0.09,1.84 -0.88,1.78 -0.85,0.38 -1.49,1.05 -2.44,1.16 -0.81,0.55 -1.13,1.54 -2.06,1.97 -0.89,0.79 -2.07,1.87 -1.34,3.13 -0.41,1.52 -2.45,1.85 -3.28,3.13 -0.94,1.23 1.12,1.89 2.03,1.97 0.8,-0.11 1.66,0.02 1.78,0.97 -1.53,0.52 -3.78,-0.46 -4.63,1.44 -0.28,0.84 -1.08,1.75 -2.06,1.44 -1.35,0.27 -2.54,1.13 -4,1.03 -1.65,-0.08 -3.01,0.87 -4.47,1.41 -0.84,0.34 -1.48,-0.08 -2.13,-0.5 -0.95,0.03 -0.92,1.52 -0.34,2.09 -0.14,0.05 -0.28,0.11 -0.41,0.19 -0.23,0.76 -1.27,1.04 -1.22,1.97 -1,1.1 -2.76,1.3 -3.56,2.69 -0.6,0.82 -1.8,0.2 -2.5,0.97 -1.06,0.66 -2.41,1.12 -3,2.28 -1.03,0.15 -3.02,0.22 -2.91,1.66 0.68,1.49 2.65,2.25 4.03,1.19 2.49,-0.73 5.03,0.64 6.88,2.16 0.21,0.75 -0.28,1.29 -0.94,1.44 -0.83,1.16 1.13,1.48 1.75,2.06 0.74,0.5 1.28,1.76 0.91,2.5 -0.86,-0.33 -1.72,-1.08 -2.63,-0.5 -1.92,0.21 -3.99,-0.12 -5.84,0.44 -0.71,1.15 1.14,1.97 1.59,2.91 0.45,0.71 0.83,1.64 1.81,1.66 1,0.58 2.01,1.14 3.13,1.38 0.81,0.41 -0.56,0.78 -0.91,0.75 -1.38,0.05 -2.91,-0.22 -4,0.81 -1.09,0.27 -0.85,-1.44 -1.78,-1.63 -0.78,-0.27 -0.68,-1.38 -1.59,-1.59 -0.83,-0.67 -1.37,-1.58 -1.38,-2.63 -0.53,-1.74 -2.79,-1.36 -4,-0.63 -1.37,0.48 -2.76,-0.39 -3.88,-0.91 -1.23,0.68 -1.99,2.15 -3.56,2.22 -1.61,0.06 -2.72,-1.53 -4.22,-1.78 -1.35,-0.88 -2.3,-2.6 -4.16,-2.44 -2.09,-0.1 -4.29,-0.57 -6.34,-0.09 -0.61,1 -0.41,2.33 -1.22,3.28 -0.54,1.77 -1.79,3.34 -1.97,5.19 0.04,0.79 -1.37,0.99 -1.16,1.91 -0.41,0.34 -1.19,0.43 -0.97,1.22 0.43,1.32 -0.64,2.45 -0.53,3.78 -0.14,0.64 -0.14,1.79 -0.78,2.06 -0.39,-1.46 -0.19,-3.06 -0.59,-4.5 -0.01,-0.97 -1.25,-1.21 -1.16,-2.22 -0.84,-1.44 -3.32,-0.86 -3.94,-2.44 0.36,-0.53 0.56,-1.62 -0.44,-1.53 -0.73,-0.01 -1.65,0.93 -2.28,0.44 0.48,-0.97 1.49,-1.45 2.41,-1.81 0.81,-1 1.19,-2.59 0.72,-3.81 -0.65,-0.74 -1.18,0.33 -1.34,0.78 -0.8,0.3 -1.32,-0.39 -1.09,-1.16 0.15,-1.17 0.48,-3.22 -1.19,-3.41 -1.75,0.14 -3.7,-2 -5.22,-0.34 -0.82,0.49 -1.07,1.77 -1.91,2.09 -0.92,-0.17 -0.99,-1.55 -2.06,-1.59 -1.37,-0.36 -2.91,0.69 -4.16,-0.41 -0.61,-0.66 -1.52,-0.58 -2.13,0 -1.74,0.47 -3.63,0.19 -5.13,-0.78 -1.36,-0.64 -2.9,-0.72 -4.22,0.06 -1.9,0.35 -4.09,0.38 -5.66,-0.84 -0.85,-0.16 -1.54,-0.59 -2.16,-1.09 -0.87,-0.25 -2.01,0.96 -2.47,-0.28 -0.51,-0.65 -1.01,-0.04 -1.31,0.34 -0.91,0.58 -2.58,1.01 -2.66,2.22 0.76,1.37 2.4,2 3.91,1.63 0.88,0.29 1.8,1.08 2.19,1.91 -0.65,0.51 -0.86,1.6 0.13,1.88 0.48,0.46 1.6,0.26 1.88,0.81 -0.24,0.7 -1,1.18 -1.69,0.66 -1.48,-0.7 -3.17,-1.34 -3.88,-2.97 -1.03,-0.43 -2.21,0.65 -3.13,1.19 -0.8,0.87 -0.51,2.24 -0.59,3.34 0.01,0.95 2.08,1.08 1.44,2.03 -0.71,0.01 -1.43,0.19 -1.97,0.75 -1.23,0.89 -2.93,0.29 -4.19,0.97 -0.58,1.14 0.93,1.07 1.59,1.09 0.51,0.67 -0.74,1.39 -1.03,1.94 -0.73,0.62 -1.19,1.64 -0.22,2.28 0.39,0.46 1.33,1.24 0.69,1.84 0.01,1.34 1.96,2.03 1.94,3.28 -1.54,0.42 -3.2,0.7 -4.69,1.34 -0.87,0.89 0.06,2.3 0.34,3.31 0.95,2.15 4.97,0.45 3.81,-1.75 -0.36,-0.98 0.92,-0.84 1.47,-1.03 0.78,-0.4 -0.07,-2.18 1.19,-1.84 1.08,0.3 1.68,-0.64 2.25,-1.28 0.61,0.05 0.26,1.44 0.53,1.88 0.41,1.1 -1.84,-0.26 -1.44,1.16 0.2,0.48 1.06,0.8 0.34,1.28 -0.77,0.65 -0.41,1.48 -0.13,2.19 -0.32,0.38 -1.01,0.73 -1.09,1.41 -0.18,0.63 -0.82,0.91 -1.25,0.34 -1.42,-0.02 -2.23,2.37 -0.88,3.19 0.65,0.43 1.52,0.57 1.78,1.41 0.47,0.38 1.21,0.23 1.34,1 0.2,0.81 1.56,1.33 1.28,2.19 -0.78,0.24 -2.11,1.29 -0.97,2 0.68,0.33 1.53,0.06 1.91,-0.5 1.09,-0.51 0.99,1.05 1.13,1.69 -0.04,1.49 0.99,3.15 0.13,4.5 -0.33,0.88 0.36,1.77 1.28,1.63 2.14,1.13 4.8,0.11 7.03,0.88 0.7,-0.38 1.37,-0.29 2.06,0.03 1.32,0.2 3.43,0.72 4.03,-0.78 0.85,0.17 0.82,1.65 1.78,1.72 0.8,1.44 -0.58,2.78 -0.53,4.25 -0.03,1.21 -1.25,1.04 -2.03,1.31 -0.48,0.62 -0.4,1.5 -0.81,2.19 0.25,1.65 2.51,1.15 3.63,1.72 0.75,0.74 -0.17,1.69 -0.94,1.94 -0.62,0.62 -1.05,1.56 -2.09,1.41 -1.2,0.27 -2.32,0.07 -3.44,-0.28 -1.47,-0.15 -2.97,-0.07 -4.25,0.69 -1.6,0.27 -3.58,0.75 -4.94,-0.38 -1.38,-0.22 -2.3,1.38 -3.69,1.25 -1.41,0.37 -3.26,0 -4.41,1 0.08,0.72 0.73,1.39 0.53,2.25 0.1,1.37 -0.61,2.52 -1.16,3.69 0.12,0.88 -0.54,1.75 0.13,2.59 0.81,1.09 -0.96,2.63 0.47,3.44 0.83,0.32 1.74,0.64 1.75,1.69 1.43,1.61 3.87,1.86 5.44,3.34 1.22,0.91 2.65,-0.14 3.91,0.44 1,0.15 2.16,-0.28 3.06,-0.06 0.34,0.83 -0.2,1.92 -1.19,1.47 -1.81,-0.72 -3.79,0.23 -5.59,-0.13 -0.47,-0.49 -1.15,-0.4 -1.44,-1.06 -1.38,-0.76 -3.06,-0.69 -4.56,-0.94 -1.04,0.66 -2.03,1.82 -3.44,1.66 -1.75,0.08 -3.32,-0.74 -4.97,-1.09 -0.81,0.31 -2.71,-0.1 -2.16,1.34 0.88,1.58 2.59,2.41 4.38,2.38 0.63,-0.02 0.99,0.19 0.75,0.84 -0.25,0.68 0.63,1.4 0.47,1.91 -1.14,-0.01 -2.27,0.45 -3.31,0.72 -1.12,-0.91 -1.54,-3.39 -3.47,-2.78 -0.9,0.34 -2.44,-1.18 -2.75,0.28 -0.17,0.62 1.36,0.99 0.75,1.44 -2.1,0.04 -4.25,-0.82 -6.34,-0.28 -0.89,1.02 0.91,1.17 1.59,1.19 1.55,-0.23 0.81,2.23 2.31,2.28 1.82,0.19 3.6,1.04 5.34,1.41 0.74,1.28 -1.51,0.76 -1.31,1.91 0.5,1.05 2.24,0.47 2.75,1.06 0.16,1.06 0.54,2.39 -0.66,3 -0.67,0.45 -1.61,0.64 -1.75,1.63 -0.33,0.82 -1.75,1.33 -2.44,0.81 -0.19,-1.34 -2.31,-1.86 -2.91,-0.59 0.09,1.08 -0.61,2.81 0.56,3.44 1.34,0.19 2.72,-0.52 3.69,-1.31 1.07,0.69 3.25,1.3 2.75,3 -0.11,1.66 2.2,1.49 3.31,1.66 1.18,-0.14 2.92,0.6 3.75,-0.5 0.44,-1.5 0.21,-3.76 2,-4.44 0.45,0.35 1.4,1.11 1.63,0.09 -0.04,-0.6 -0.03,-1.42 0.78,-1.06 1.06,0.25 2.12,0.75 2.66,1.69 0.72,0.21 1.77,-0.21 2.09,0.84 0.42,0.99 0.68,2.87 -0.56,3.31 -0.88,0.01 -1,1.28 -1.63,1.5 -1.11,-0.58 -2.49,0.3 -3.44,0.91 -0.42,0.64 0.42,1.3 -0.03,2.06 -0.19,1.77 2.05,2.42 3.44,2.53 1.28,-0.34 0.9,1.43 1.88,1.78 1.13,0.77 2.38,-0.18 3.56,-0.22 0.81,-0.57 0.12,-1.91 1.09,-2.41 0.63,-0.65 0.77,-1.57 1.47,-2.19 0.17,-0.59 0.33,-0.99 0.59,-1.5 -0.03,-0.46 -0.64,-1.18 0.22,-1.19 1.13,0.22 1.79,-0.65 2.16,-1.56 0.46,-0.19 1.28,-0.61 1.66,-0.31 0.25,1.07 1.34,1.04 2.16,0.78 1.3,0.28 3.17,-1.18 4.03,0.34 0.39,0.95 -0.96,0.5 -1.44,0.56 -1.06,-0.02 -2.6,1.42 -1.31,2.25 0.78,0.54 2.2,0.57 2.66,1.44 -0.86,1.59 -2.8,2.14 -4.47,2.28 -0.79,0.79 0.75,1.06 0.47,1.94 0.51,1.06 0.64,2.25 1.06,3.31 1.09,0.23 1.51,-1.54 2.44,-1.63 0.5,0.47 1.76,1.22 0.88,1.94 -0.81,1.28 0.15,2.77 0,4.19 0.09,0.81 0.99,0.79 1.34,1.41 1.19,0.26 2.33,-0.69 3.56,-0.44 1.86,-1.1 4.24,-0.43 6.19,-1.22 3.52,-0.49 7.12,-0.53 10.63,-1.13 1.88,-0.31 4.06,0.52 5.72,-0.63 0.54,-0.83 1.67,-0.76 2.44,-0.34 1.66,0.2 2.46,-1.88 4.19,-1.41 2.17,0.08 4.34,-0.09 6.47,-0.34 1.21,0.13 0.14,1.76 -0.38,2.16 -0.88,0.1 -1.29,1.37 -0.22,1.53 0.93,0.41 -0.34,1.29 -0.94,1.03 -1.53,0.05 -0.87,2.6 0.53,2.09 1.84,0.22 3.07,-1.58 4.78,-1.72 0.57,0.62 -0.8,1.14 -0.97,1.69 -0.34,1.07 -1.58,0.96 -2.03,1.91 -0.86,1.24 -1.44,2.83 -0.63,4.22 0.18,0.73 0.23,1.59 0.97,1.97 -0.1,1.12 -1.65,0.37 -1.91,-0.31 -0.36,-0.93 -2.49,-1.72 -2.53,-0.25 0.32,0.83 -1.02,1.02 -1.59,1.09 -1.89,-0.92 -3.86,-2.25 -6.06,-1.88 -0.43,0.55 0.82,1.84 -0.22,2.19 -1.45,0.15 -1.76,2.54 -3.41,2.16 -1.45,-0.59 -2.36,-2.13 -4.03,-2.19 -1.3,-0.13 -2.19,-1.75 -3.5,-1.38 -1.78,1.35 -0.87,4 -2.25,5.63 -0.59,2.25 -3.75,2.38 -4.13,4.75 0.22,1.92 -2.41,2.6 -2.25,4.53 0.23,0.44 0.37,1.05 0.72,1.38 l -0.19,0 -0.22,0.09 -0.13,0.06 c -1.13,1.11 -2.34,2.41 -2.31,4.09 -0.59,1.25 -2.06,1.92 -2.63,3.19 0.63,1.1 2.24,-0.34 3.06,0.66 1.54,0.49 2.7,-1.47 4.19,-1.13 0.89,0.89 1.3,2.6 0.22,3.47 -1,0.78 -1.59,2.02 -2.88,2.47 -1.05,0.46 -2.99,1.37 -1.94,2.78 0.04,0.91 -1.07,1.88 -0.41,2.78 0.15,0.81 -0.11,1.48 -0.84,1.81 -0.56,1.03 -1.26,2.01 -2.31,2.59 -0.89,1.19 0.34,2.82 -0.56,4.06 0.03,1.26 -0.61,2.52 -1.81,3.03 -0.57,0.3 -1.22,1.59 -1.84,0.63 -0.6,-1.01 -1.82,-1.91 -2.91,-0.97 -0.76,0.27 -1.2,1.02 -1.63,1.53 -1,0.22 -0.62,1.42 -0.66,2.06 -1.34,0.47 -2.8,2.09 -1.78,3.5 -0.03,1.34 -1.61,0.16 -2.25,0.94 -2.06,1.93 -4.08,3.98 -6.63,5.25 -1.51,1.1 -1.72,3.82 -3.94,3.91 -1.83,-0.02 -2.68,2.18 -4.47,2.31 -0.81,0.17 -1.76,1.63 -0.47,1.81 1.42,0.41 2.3,-0.84 3.31,-1.5 1.22,-0.39 2.38,0.28 3.56,0.25 1.7,-0.26 3.22,-1.2 4.53,-2.25 0.84,0.06 2.45,0.62 1.97,-0.84 -0.63,-1.12 0.37,-2.47 1.59,-2.25 1.7,0.21 3.24,-0.62 4.91,-0.69 0.97,-0.76 2.19,-1.19 3.31,-1.66 0.74,-1.08 -0.54,-2.1 -1.53,-2.28 -0.45,-0.25 -1.15,-1.32 -0.16,-1.28 1.08,-0.03 2.5,-0.44 3.44,0.13 0.14,1.08 -0.47,2.83 0.88,3.28 0.56,0.88 1.85,-0.23 2.41,0.47 -0.06,1.58 2.18,1.83 3.31,2.19 0.93,0.62 2.37,1.55 3.19,0.22 0.42,-1.27 2.17,-0.05 2.78,-1.25 0.87,-0.91 2.45,-0.65 3.34,-1.63 0.76,-0.35 1.96,-0.83 2.66,-0.31 -0.41,1.46 -2.26,2.05 -3.25,3.09 -0.94,0.5 -1.93,1.99 -0.47,2.53 2.06,0.9 3.57,-1.43 3.97,-3.16 0.91,-1.15 2.71,-0.25 3.94,-0.41 0.95,0.05 1.88,-0.17 2.78,-0.25 1.07,-0.82 1.7,-2.12 2.72,-2.97 0.57,-0.66 0.51,-1.7 0.88,-2.38 0.77,-0.04 1.72,-0.27 1.69,-1.25 1.18,-1.23 0.53,-3.37 2.13,-4.28 0.8,-0.35 1.36,-1.76 0.09,-1.81 -0.48,0.08 -1.37,-0.07 -0.78,-0.66 1.33,-1.33 2.84,-2.77 4.84,-2.75 1.22,-0.13 3.07,-1.33 1.75,-2.56 -0.33,-0.41 -0.01,-1.48 0.47,-0.84 0.39,0.92 2.07,-0.37 2.06,0.69 -1.18,0.93 -0.88,2.67 -2.22,3.47 -0.36,1.17 1.76,1.94 1.31,3.25 -0.83,0.5 -0.32,1.52 0.47,1.59 0.93,0.73 -0.87,1.49 -1.13,2.16 -1.03,1.24 0.93,1.17 1.72,0.81 1.39,-0.37 2.75,-1.68 4.25,-0.84 1.08,0.55 2.3,1.15 3.47,0.5 0.56,0.03 0.16,1.09 0.91,1.13 2.01,0.7 4.51,-0.04 6.22,1.34 0.28,0.79 0.6,1.86 1.69,1.41 1.16,-0.28 3.06,-0.17 2.75,-1.91 0.12,-0.49 0.04,-1.98 0.81,-1.75 0.19,1.47 0.34,3.82 -1.56,4.16 -1.32,0.23 -3.04,1.09 -4.25,0.19 -0.64,-1.45 -2.35,-2.4 -3.81,-1.5 -1.31,0.36 -0.57,2.15 -1.69,2.63 -0.56,-0.88 -1.48,-1.51 -1.91,-2.44 -1.65,-0.7 -3.6,-0.03 -5.03,0.84 -0.93,-0.14 -1.85,0.09 -2.63,0.56 -1.34,-0.77 -2.81,0.64 -3.41,1.75 -0.33,0.78 0.82,2.01 -0.38,2.31 -0.63,0.07 -1.33,0.81 -1.94,0.09 -1.16,-0.91 -3.5,0.49 -2.25,1.81 0.32,0.99 -1.57,0.72 -1.97,0.34 0.02,-1.35 -1.4,-1.71 -2.5,-1.5 -1.45,0.24 -2.74,1.11 -4.19,1.41 -1.38,1.26 -3.45,0.81 -4.94,1.91 -1.48,1.08 -3.18,1.67 -5.03,1.44 -1.21,-0 -2.56,0.14 -3.44,-0.84 -1.64,-0.35 -3.62,-0.56 -5.16,0.25 -1.11,0.78 -0.27,2.87 -1.75,3.31 -0.52,-0.57 -0.2,-1.97 -1.16,-2.41 -1.31,-0.96 -2.53,0.79 -3.91,0.09 -1.73,-0.4 -3.79,-1.97 -5.44,-0.44 -1.39,0.79 -2.17,2.33 -2.06,3.88 -0.35,1.7 -0.82,3.5 -0.63,5.22 0.85,0.15 1.99,-0.23 2.59,0.72 0.4,0.51 1.01,1.63 0.41,2.09 -0.51,-0.27 -1.1,-0.92 -1.78,-0.88 -1.69,-1.22 -4.28,-0.31 -5.63,1.06 -0.57,1.44 -2.06,2.17 -3.44,2.66 -2.24,1.3 -4.76,1.89 -7.34,1.53 -1.07,0.08 -2.94,0.96 -2.41,2.25 1.79,1.74 4.61,1.29 6.78,2 0.91,1.16 0.2,2.95 0.38,4.31 -0.06,1.23 -0.1,2.56 0.56,3.59 -0.02,1.5 -0.68,2.94 -1.16,4.25 0.66,1.12 2.58,1.11 3.84,1.03 1.2,-0.29 2.04,0.83 2.88,1.38 0.57,0.11 1.94,-0.59 1.66,0.5 -0.52,0.85 -1.99,0.3 -2.63,1.19 -0.6,1.05 -1.66,-0.51 -2.5,0.19 -0.87,0.56 -2.11,0.99 -2.97,0.25 -1.01,0.13 -1.59,1.24 -2.66,1.38 -1.82,0.77 -3.92,0.49 -5.75,-0.03 -1.75,-1.25 -3.68,-2.51 -4.66,-4.47 -1.06,-0.17 -1.43,1.52 -2.31,2 -1.32,1.38 -3.33,1.45 -5.03,2.09 -0.96,-0.07 -2.01,0.55 -2.75,0.69 -0.42,-1.4 1.78,-1.97 1.41,-3.44 -0.28,-1 0.31,-2.44 -0.53,-3.19 -1.38,-0.23 -1.94,1.36 -2.78,2.06 -0.75,-0.14 -1.67,-0.7 -2.38,0.03 -0.9,0.42 -0.91,1.82 -2.09,1.66 -1.14,0.45 -1.25,2.11 -2.59,2.25 -1.01,0.48 -2.32,0.41 -3.19,1.06 -0.29,0.86 1.43,1.14 0.69,2.03 -0.84,0.67 -1.32,1.75 -0.5,2.63 0.38,0.83 -0.8,2.39 -1.47,1.28 -0.69,-0.53 -2.41,-0.17 -2.25,-1.47 -0.46,-1.08 -1.99,-0.18 -2.59,0.25 -0.29,0.98 2,0.61 1.19,1.66 -0.88,0.8 -1.73,1.79 -1.44,3.09 0.16,1.5 -0.12,3.24 0.56,4.59 1.3,0.57 2.78,-0.15 4,-0.56 1.07,0.12 0.96,-1.04 1,-1.72 0.24,-0.98 1.28,-1.42 2.09,-0.75 0.75,0.51 2.41,1.25 2.47,-0.22 0.71,-0.93 2.39,-1.57 3.09,-0.25 0.23,0.96 1.28,1.75 2.28,1.28 0.66,-0.4 -0.22,-1.7 0.91,-1.66 1.3,0.09 0.26,1.55 1.03,2.16 0.7,1.05 1.7,0.12 2.47,-0.22 0.8,-0.39 1.53,0.05 2.22,0.31 0.91,-0.15 1.09,-1.57 2.16,-1.19 2.86,-0.77 5.67,-2.13 8.69,-2 2.33,-0.81 4.81,-1.31 7.19,-1.84 1.42,0.41 2.88,-0.38 4.25,-0.03 0.6,0.61 1.39,0.44 2,0.03 1.05,-0.3 1.74,1.06 1.16,1.81 -0.87,0.16 -2.46,-0.96 -2.75,0.41 0.05,1.09 1.31,1.27 1.78,2 0.13,0.83 -0.92,1.66 -1.63,1.59 0.24,-0.85 -0.11,-2.31 -1.28,-1.91 -0.53,0.54 -1,0.85 -1.78,0.5 -1.08,-0.24 -0.46,1.59 -1.41,1.31 -2.02,-0.3 -4.13,1.1 -5,2.84 -0.08,0.78 1.17,1.68 0.72,2.38 -1.2,-0.08 -2.45,0.11 -3.34,1 -1.85,1.49 -4.07,2.56 -6.5,2.38 -1.28,0.22 -1.99,1.74 -3.44,1.47 -1.72,-0.27 -2.64,1.4 -4.16,1.75 -0.93,0.49 -1.67,1.39 -2.25,2.19 -1.54,-0.93 -3.85,0.43 -3.28,2.28 0.32,0.83 -1.6,0.41 -1.13,1.44 1.25,0.78 3.21,0.49 4.22,-0.63 0.61,-0.27 1.74,-1.22 2.28,-0.53 0.47,0.88 -0.79,1.17 -1.22,1.72 -1.36,0.11 -2.6,0.78 -3.63,1.63 -1.03,0.26 -0.19,1.14 0.22,1.56 0.36,0.6 0.44,2.08 -0.34,2.16 -0.9,-1.13 -1.82,0.33 -2.5,0.91 -1.1,0.53 -2.51,0.44 -3.5,1.25 -0.83,0.31 -2.63,-0.25 -2.5,1.19 0.16,0.95 0.16,1.94 -0.16,2.84 0.45,1.2 1.71,-0.26 2.59,0.06 1.09,-0.32 1.61,1.12 1.16,1.91 -0.12,1.32 0.13,2.71 -0.38,3.94 0.31,1.19 1.75,-0.03 2.19,-0.63 0.62,-0.82 2,-0.98 1.84,-2.25 0.42,-0.79 1.21,-1.37 1.34,-2.28 1.05,-0.57 2.58,-0.73 3.69,-0.22 0.96,0.8 2.28,1.68 1.84,3.13 0.17,0.91 0.22,1.7 -0.22,2.56 0.05,0.78 -0.69,0.98 -1.09,1.44 -0.23,1.48 1.86,1.32 2.78,1.75 0.61,0.58 1.43,0.68 1.94,-0.09 0.63,0.17 1.14,1 1.97,0.81 0.91,0.12 1.72,-0.45 1.94,-1.28 0.83,-0.78 1.99,-0.54 2.97,-0.38 1.6,-0.79 2.76,-2.35 4.47,-3.03 0.86,-0.71 3.07,-0.03 2.66,-1.66 0.02,-0.65 -0.56,-2.1 0.28,-2.41 0.54,0.42 0.21,2.03 1.41,1.81 0.78,0.78 2.38,1.07 2.94,-0.13 0.86,-0.84 1.96,-1.14 3.06,-1.38 2.7,-1.89 6,-2.85 9.06,-4.06 1.99,-0.24 4.25,0.11 5.88,-1.34 0.49,-0.42 1.61,-0.32 1.13,0.53 -0.53,1.15 -2.17,1.05 -3.06,1.84 -1.64,0.59 -2.58,2.57 -4.5,2.31 -1.91,0.15 -4.22,0.48 -5.19,2.38 -0.78,0.7 -1.89,1.24 -1.81,2.47 -0.57,0.42 -1.72,0.2 -2.16,1 -0.62,0.92 0.54,1.31 1.13,1.69 0.63,0.59 0.4,1.59 -0.53,1.63 -1.07,0.25 -2.23,-0.95 -3.25,-0.06 -0.69,0.56 -0.84,1.65 -1.84,1.78 -0.36,0.7 -1.52,0.78 -1.72,-0.06 -1,-0.83 -1.59,0.67 -2.5,0.75 -1.01,0.09 -1.73,0.72 -2.72,0.78 -0.96,0.19 -1.31,1.84 -0.06,1.78 0.7,0.17 2.22,-0.44 1.72,0.72 -0.5,0.72 -1.05,1.48 -1.22,2.41 -0.34,1.14 -1.97,0.64 -2.41,1.75 -1.05,0.09 -2.15,0.12 -3.13,0.56 -1.26,-0.33 -2.26,0.95 -0.63,1.38 0.68,0.66 0.24,1.94 0.25,2.81 -0.26,2.05 -3.11,1.12 -4.06,2.47 0.05,1.35 1.86,0.5 2.69,0.56 1.31,-0.25 2.48,0.23 3.66,0.66 1.51,-0.38 2.33,-2.15 3.75,-2.69 0.66,0.34 1.84,0.86 2.06,-0.28 0.1,-0.68 -0.17,-1.57 0.72,-1.81 0.7,-0.66 1.47,-1.65 2.56,-1.38 1.46,-0.51 2.98,-0.84 4.56,-0.72 1.55,-0.1 3.22,-0.35 4.47,-1.25 1.08,0.03 1.4,-1.21 0.94,-1.94 0.37,-0.59 1.06,-1.17 1.44,-0.22 0.29,0.6 0.58,1.35 1.47,1.13 0.67,0.15 1.55,-0.76 2.06,-0.34 0.78,1.16 2.26,0.11 2.94,-0.59 0.98,-0.61 2.01,-1.32 2.41,-2.41 0.82,-0.33 2.07,-0.47 1.94,-1.69 0.08,-1.04 -0.21,-3.16 1.25,-3.31 1.14,0.58 0.56,2 1.63,2.63 0.68,0.75 1.89,1.68 2.75,0.63 0.47,-0.19 1.37,-1.78 1.56,-0.69 0.69,1.38 -0.56,2.75 0.25,4.09 0.06,0.93 -0.98,1.77 -1.81,2.13 -1.59,0.36 -2.58,1.93 -4.22,2.22 -2.64,0.79 -4.85,2.55 -7.47,3.38 -1.77,0.85 -3.67,1.89 -5,3.25 -1.57,0.56 -3.05,1.54 -4.28,2.66 0.03,0.65 -0.32,0.99 -0.97,1.16 -1.15,0.85 0.78,1.8 1.53,1.13 1.51,-1.14 3.36,-1.71 5.03,-2.47 0.8,-1.46 3.2,-0.46 3.84,-2.19 0.12,-0.99 1.36,-0.39 1.91,-0.97 1.1,-0.69 2.24,-1.25 3.56,-1.28 0.56,-0.16 1.52,-1.08 1.75,-0.06 0.37,0.96 -0.53,2.07 -1.5,1.59 -1.26,0.07 -1.24,1.52 -2.25,1.94 -1.07,0.68 -1.69,1.82 -2.94,2.28 -0.83,0.48 -0.36,1.61 -1.19,2.06 -0.26,1.44 -2.05,1.47 -3.09,2.06 -1.68,0.63 -3.79,0.69 -4.81,2.41 -0.74,1.12 -2.31,1.38 -2.91,2.53 0.09,0.69 1.14,1.48 0.28,2.09 -0.54,0.73 0.12,2.25 1,1.31 1.11,-0.59 0.46,-2.06 1.34,-2.72 0.47,-0.35 1.64,-0.38 0.94,0.47 -0.27,1 1.03,0.94 1.44,0.31 1.04,-0.54 2.36,-1.34 1.84,-2.72 0.32,-0.66 1.5,-0.16 1.72,-0.94 1.04,-0.2 1.07,-1.53 2.03,-1.78 0.29,-0.62 1.29,-0.47 1.25,0.28 0.78,0.69 0.73,2.04 1.94,2.31 1.03,0.28 0.65,-1.28 1.63,-1.19 1.05,0.03 2.71,-0.12 2.63,-1.56 -0.26,-0.83 0.73,-1.67 1.41,-1.19 0.06,0.98 1.09,1.51 1.91,0.88 0.7,-0.15 1.2,-1 1.75,-1.19 0.73,0.64 2.04,0.16 1.41,-0.88 -0.21,-0.68 -1.26,-1.96 -0.44,-2.5 0.73,0.02 0.98,1.18 1.88,1 0.8,0.05 2.06,0.18 2.44,0.94 0.27,1.46 -1.09,2.65 -1,4.03 0.83,0.82 2.32,-0.4 2.22,-1.44 0.36,-0.53 0.94,-0.88 1.13,-1.53 0.41,-0.49 1.01,0.65 1.47,-0.03 0.14,-0.56 0.32,-1.25 1.09,-1.16 0.44,0.83 0.09,1.94 -0.72,2.41 -0.34,1.06 -1.43,1.81 -1.41,3.06 -0.02,0.81 -0.04,1.58 -0.63,2.19 0.03,1.38 1.81,0.44 2.41,-0.03 1.07,-0.6 1.1,-1.96 1.16,-2.97 0.92,-0.16 1.57,0.93 2.56,0.5 0.78,-0.34 0.69,1.05 1.56,0.91 1.34,0.21 2.03,-1.1 2.91,-1.75 0.92,-0.22 0.6,-1.49 1.47,-1.84 0.81,-0.63 0.49,-1.76 0.09,-2.47 0.28,-0.69 0.96,-0.61 1.13,0.09 0.15,0.76 0.07,2.16 1.28,1.84 1.25,-0.04 2.05,-1.39 1.28,-2.44 -0.44,-0.54 -1.3,-0.54 -1.41,-1.38 -0.22,-0.56 -1.02,-2.15 0.22,-1.88 0.55,0.71 0.75,1.77 1.88,1.78 0.79,0.48 1.08,1.82 2.25,1.63 0.84,0.12 0.45,-1.32 1.28,-0.88 0.92,0.79 2.24,0.02 2.13,-1.16 0.05,-0.56 0.01,-1.23 0.44,-1.66 0.64,0.56 0.48,1.79 1.59,1.72 1.57,0.36 2.73,1.5 4.13,2.16 1.12,0.46 2.69,0.11 2.75,-1.31 0.06,-1.02 0.74,-1.68 1.53,-2.19 0.71,-0.87 -0.31,-1.64 -1.16,-1.59 -0.81,-0.78 0.58,-1.44 0.75,-2.16 0.13,-0.45 -0.94,-1.54 0.09,-1.28 0.79,0.3 1.46,1.06 2.22,1.28 0.57,0.62 -0.06,1.95 1.16,1.94 1.36,-0.13 2.61,0.29 3.78,0.91 0.68,0.34 1.16,-1.22 1.56,-0.25 0.23,1.21 1.34,2.04 2.56,1.63 1.06,-0.49 -0.01,-1.79 0.72,-2.56 0.63,-0.75 0.28,-1.63 -0.13,-2.34 0.83,-1.02 -0.49,-1.92 -1.47,-1.69 -0.79,-0.26 -1.53,-0.78 -2.38,-0.69 -0.69,-0.25 0.24,-1.2 0.75,-0.84 1.46,0.07 3.04,0.15 4.31,-0.56 0.35,-0.48 0.16,-1.79 1.13,-1.44 0.67,0.84 -0.23,2.3 1.09,2.66 1.73,0.78 3.4,-0.46 5.13,-0.38 0.57,0.79 1.68,0.43 1.75,-0.53 0.89,-1.1 1.57,-2.48 1.72,-3.88 -0.73,-0.93 -1.9,-1.27 -3,-0.94 -1.54,0.37 -2.8,-0.8 -3.34,-2.13 0.33,-1.38 -1.96,-2.16 -1.13,-3.53 0.43,-0.59 0.99,-0.06 0.94,0.53 0.4,1.22 1.97,1.77 1.72,3.22 0.31,1.65 2.15,0.86 3.06,0.34 0.78,0.66 1.64,0.29 2.31,-0.25 0.77,0.13 1.9,0 1.72,-1.06 1.13,0.18 2.31,0.76 3.5,0.81 0.17,0.73 1,1.12 1.53,0.47 1.42,0.08 2.12,-1.7 3.63,-1.31 0.92,0.18 1.35,-0.6 1.47,-1.34 0.37,-0.99 1.62,-0.72 1.84,-1.81 0.58,-0.71 0.52,-2.4 -0.75,-2.03 -0.51,0.27 -1.84,0.66 -1.59,-0.38 1.64,-0.47 3.25,-1.63 4.09,-3.13 -0.12,-1.34 -2.02,-0.71 -2.94,-0.97 -1.38,-0.21 -2.97,-0.45 -4.09,-1.25 0.2,-0.64 1.37,-0.35 1.94,-0.53 0.76,-0.13 1.79,1.06 2.09,-0.22 0.21,-1.09 -0.88,-1.55 -1.47,-2.16 0.09,-0.53 1.05,-0.69 0.94,-1.44 0.28,-1.2 -0.13,-2.99 -1.69,-2.84 -1.57,0.03 -3.39,0.33 -4.78,-0.25 -0.2,-1.06 1.51,-0.34 2.06,-0.66 1.31,-1.15 -1.33,-1.25 -2.06,-1.81 -0.1,-0.71 1.28,-0.2 1.75,-0.38 1.67,-0.11 2.95,1.32 4.69,1.19 1.37,-0.13 0.23,-1.12 -0.31,-1.56 -0.3,-0.63 1.29,-0.19 1.59,-0.34 0.68,0.16 2.22,-0.26 2.41,0.69 0.06,1.25 1.66,0.99 2.38,1.69 0.96,0.32 1.89,-0.27 2.84,-0.13 0.46,-0.35 0.76,-0.81 1.31,-1.06 0.32,-0.4 0.45,-1.42 0.91,-0.5 0.48,0.82 -0.55,1.71 0.13,2.56 -0.7,0.48 -2.49,0.68 -1.97,1.97 0.39,0.66 2.21,-0.44 1.78,0.75 -0.62,0.33 -1.2,0.82 -1.31,1.53 -0.84,0.59 -2.5,0.15 -2.63,1.59 0.38,0.84 -0.35,1.21 -1.13,1.16 -0.83,0.28 -0.44,1.22 0.09,1.56 0.4,1.87 2.78,0.93 4.09,1.19 0.71,0.14 1.44,0.96 2.09,0.09 1.18,-1.68 3.27,-1.9 5.16,-1.75 1.16,-0.08 1.79,-1.3 3.03,-1.22 1.36,-0.3 0.17,-1.58 0.44,-2.41 0.53,-1.79 2.55,-2.57 4.13,-3.22 1.67,-0.2 3.45,-0.48 4.91,-1.34 0.56,-1.11 -1.12,-0.81 -1.56,-1.47 -0.48,-0.17 -1.49,-0.27 -0.97,-1 0.74,-0.44 0.63,-1.77 1.59,-1.78 0.69,1.22 1.82,-0.1 2.16,-0.84 0.44,-0.95 2.05,-1.47 1.5,-2.72 -0.29,-1.21 -1.34,-1.93 -1.63,-3.13 -0.5,-0.61 -1.23,-1.66 -0.78,-2.41 0.5,-0.65 2.47,-0.84 1.56,0.28 -0.85,0.34 -0.6,1.46 0.28,1.38 1.28,0.71 3.02,2.12 2.13,3.75 -0.56,0.85 0.47,1.77 1.25,1.09 0.88,-0.71 2.25,-1.54 3.22,-0.5 0.56,0.79 2.18,1.11 2.28,-0.19 -0.2,-0.99 0.8,-1.43 1.03,-2.25 1.51,-1.53 3.86,-0.68 5.66,-1.59 1.61,-0.41 3.44,-1.72 2.75,-3.63 -0.03,-1.27 0.88,-2.23 1.38,-3.28 -0.24,-1.01 -1.63,-0.3 -2.16,-1.13 -0.75,-1.08 -1.97,-0.28 -2.94,-0.53 -0.69,-0.62 0.64,-1.4 0.28,-2.19 0.01,-0.86 1.52,-1.8 0.16,-2.41 -0.91,-0.18 0.05,-1.16 0.66,-0.88 0.76,0.14 1.31,1.73 1.97,0.63 -0.45,-1 1.72,-1.1 1.22,-0.13 0.08,0.94 1.4,2.67 2,1.16 0.65,-1.29 2.15,-1.85 3.5,-1.81 1.72,-1.09 3.36,-2.46 5.47,-2.75 1.24,-0.01 2.44,-0.41 3.53,-0.88 1.59,-0.09 3.21,0.17 4.78,-0.06 2.69,0.22 5.78,1.41 8.31,-0.03 0.63,-0.56 0.21,-1.64 1.19,-1.94 0.73,-0.33 1.7,-0.37 2.03,-1.25 0.74,-0.5 1.7,-0.29 2.28,0.31 0.56,0.2 1.4,-0.88 1.5,0.25 0.73,1.34 -2.17,1.79 -1.09,3.06 0.93,0.34 1.84,-0.67 2.81,-0.09 1.22,0.3 3.06,-0.26 3.06,-1.75 0.79,-0.9 1.97,-2.29 0.84,-3.41 -0.4,-1.97 0.98,-3.99 0.41,-5.91 -0.67,-0.89 -1.96,-1.57 -1.5,-2.91 0.15,-0.68 -0.74,-1.51 -0.03,-2.03 0.69,-0.13 2.39,-0.65 2.16,0.53 0.16,1.03 -1.13,2.46 0.22,3.09 1.65,0.72 2.25,2.59 3.47,3.78 1.33,1.63 0.46,3.9 1.31,5.66 1.74,0.31 3.92,-1.27 3.75,-3.22 0.35,-0.73 0.27,-1.72 -0.66,-1.88 0.04,-0.81 0.78,-1.53 0.88,-2.34 1.15,-0.02 1.9,-0.95 2.34,-1.84 1.07,0.09 2.27,-0.6 2.16,-1.81 0.08,-0.72 0.68,-0.52 0.75,0.09 0.46,0.93 0.49,1.88 -0.53,2.44 -0.67,0.87 -1.91,2.1 -1.25,3.25 0.94,0.46 1.82,-0.69 2.84,-0.53 1.46,-0.21 2.93,-1.04 4.41,-0.34 0.7,0.49 1.29,-0.82 1.81,-0.38 0.11,0.77 0.68,1.26 1.28,1.66 0.29,0.53 -2.6e-4,1.21 0.69,1.59 0.99,0.85 2.03,2.74 3.47,1.56 1.41,-0.9 3.23,-0.8 4.59,-1.69 0.46,-0.55 -0.23,-2.09 0.88,-2.03 0.53,0.75 1.66,0.12 2.09,1 0.81,0.2 0.99,0.96 1.41,1.53 0.96,0.5 2.03,0.57 2.91,1.28 1.49,0.72 2.07,-1.35 2.13,-2.44 -0.1,-1.86 2.2,-2.98 1.72,-4.84 -0.78,-1.22 -2.76,-0.31 -3.31,-1.81 -0.63,-1.06 -0.86,-3.31 -2.56,-3 -0.43,0.14 -1.02,0.97 -1.19,0.13 -0.08,-1.7 -1.58,-3.01 -1.34,-4.75 -0.15,-1.51 -1.62,-2.26 -2.78,-2.81 -0.55,-0.02 -1.88,0.08 -0.97,-0.72 0.74,-0.57 1.09,-1.47 1.63,-2.13 0.49,-0.47 1.86,-0.88 1.69,0.22 -0.5,0.68 -0.75,2.42 0.56,2.22 1.71,-1.07 3.79,-0.12 5.63,-0.5 0.1,-1.36 -0.18,-2.87 0.25,-4.25 0.41,-2.97 3.02,-4.86 4.25,-7.47 1.79,-3.17 3.81,-6.17 5.63,-9.31 0.92,-1.43 1.12,-3.26 0.13,-4.72 -0.09,-1.56 -0.46,-3.06 -1.06,-4.5 -0.5,-1.85 0.17,-3.65 0.91,-5.31 0.6,-2.32 2.19,-4.3 3.56,-6.22 1.45,-1.8 0.77,-4.33 1.06,-6.47 -0.06,-1.64 0.44,-3.15 1.44,-4.44 0.44,-1.73 1.78,-3.28 3.22,-4.28 1.24,-0.54 0.42,-2.32 1.16,-3.28 0.6,-1.01 1.18,-2.04 1.25,-3.25 1.04,-1.51 1.19,-3.31 1.91,-4.91 0.79,-0.54 0.46,-1.76 -0.53,-1.63 -1.43,-0.83 -2,-2.53 -2.34,-4 -0.04,-4.5e-4 -0.08,4.5e-4 -0.13,0 0.47,-0.81 0.1,-2.13 0.41,-3.06 0.54,-2.72 0.97,-5.55 0.5,-8.34 -0.08,-3.07 -2.77,-5.39 -2.47,-8.53 -0.1,-1.45 -1.61,-2.24 -1.72,-3.69 -0.34,-1.8 -0.95,-3.79 -0.47,-5.59 0.64,-0.66 1.31,-2.06 0.06,-2.53 -2.02,-1.29 -4.77,-1.44 -6.25,-3.5 -0.35,-1.32 -0.86,-2.59 -1.72,-3.66 -0.2,-0.86 -0.38,-2.27 0.94,-1.81 1.24,0.05 2.64,0.12 3.16,-1.31 0.62,-0.97 1.63,-1.48 2.66,-1.91 0.51,-1.05 -1.07,-2.12 -0.59,-3.16 1.56,-0.81 0.66,-2.84 -0.69,-3.31 -1.18,-0.75 -3.25,-0.69 -3.91,-2.06 0.27,-0.84 1.32,0.03 1.91,-0.5 0.97,-0.2 1.86,-1.27 2.84,-0.53 1.31,0.31 2.62,-2.3 0.84,-2.5 -1.02,-0.24 -2.52,0.31 -3.28,-0.47 0.98,-1.88 3.49,-1 4.94,-2.09 0.72,-1.2 1.18,-2.92 0.69,-4.28 -0.59,-0.67 -0.91,-1.47 -1.38,-2.19 -0.95,-1.03 -2.67,-0.5 -3.41,-1.81 -0.43,-0.63 -0.49,-1.45 -1.28,-1.81 -0.71,-0.91 -0.83,-2.33 -2.13,-2.72 -1.22,-1.54 -1.46,-3.72 -2.06,-5.56 -0.61,-1.42 -0.08,-3.21 -1,-4.47 -1.47,-0.53 -2.98,0.74 -4.53,0.56 -0.67,0.26 -1.07,-0.52 -0.28,-0.63 1.42,-0.38 2.75,-1.08 3.81,-2.06 1.11,0.43 1.44,-0.88 1.31,-1.72 0.13,-1.56 0.76,-3.05 1.06,-4.53 -0.38,-0.84 -1.74,-0.82 -1.78,-1.94 -0.42,-1.94 0.73,-3.81 0.78,-5.69 -0.74,-0.88 -1.98,-0.78 -2.84,-1.31 -0.95,-0.89 -2.48,0.16 -3.38,-0.97 -2.39,-2.12 -2.26,-5.58 -2.53,-8.47 0.6,-0.82 1.45,-1.69 1,-2.81 0.18,-1.02 2.24,-1.71 1.25,-2.84 -1.09,-0.64 -2.85,-0.03 -3.66,-1.06 0.22,-0.87 1.1,-0.75 1.75,-0.44 1.94,0.35 4.3,-0.63 5.84,1.06 1.61,1.43 3.52,2.38 5.66,2.69 1.74,0.33 3.82,0.74 5.13,-0.81 0.81,-0.51 1.66,-1.63 0.59,-2.38 -0.91,-0.47 -0.59,-2.09 -1.88,-1.94 -1.02,-0.41 -2,-1.09 -2.75,-1.84 -0.64,-1.67 -2.15,-2.59 -3.53,-3.56 -0.74,-0.71 -1.23,-1.7 -2.31,-1.88 -0.58,-0.87 -1.66,-1.25 -1.88,0.06 -0.83,0.94 -2.12,0.64 -3.16,0.88 -0.59,0.65 -0.08,1.8 -1.03,2.28 -1.57,1.14 -3.59,1.09 -5.34,1.72 -1.21,0.21 -1.12,-2.11 -2.25,-1.19 -1.81,2.11 -4.74,1.6 -7.19,2.03 -1.11,0.77 -3.08,1.69 -4.03,0.19 -0.85,-1.29 -2.75,-2.29 -2.19,-4.03 0.02,-1.53 0.81,-2.98 0.25,-4.5 0.37,-1.93 2.59,-3.86 1.22,-5.84 -0.6,-1.1 -2.01,-3.02 -3.38,-1.84 -0.93,1.27 -3.2,1.27 -3.78,-0.31 -1.86,-0.85 -3.54,-2.27 -4.41,-4.16 -0.11,-1.27 -1.09,-2.23 -1.19,-3.5 -0.92,-0.89 -2.81,-1.37 -2.94,-2.84 -0.11,-1.28 1.91,-1.73 1.22,-3.13 -0.66,-1.4 -0.46,-3.93 -2.47,-4.16 -1.29,-0.58 -0.24,-2.57 -1.72,-3 -1.58,-1.35 -2.85,-3.25 -4.94,-3.84 -0.76,-0.73 -2.13,-0.87 -2.53,0.31 -0.68,1.68 -1.89,3.03 -2.88,4.5 -0.53,2.31 -3.16,2.95 -4.78,4.25 -0.47,0.82 -0.18,1.93 -0.97,2.63 -0.21,0.7 0.53,1.17 0.56,1.84 0.5,0.58 1.41,0.65 1.63,1.53 1.02,1.73 0.74,3.94 0.25,5.78 -0.59,0.82 -1.49,1.34 -2.5,1.03 -1.53,0.02 -3.03,0.98 -3.41,2.47 -0.91,0.2 -1.01,1.25 -0.44,1.91 0.1,1.6 -0.8,3.1 -1.44,4.53 -0.64,1.42 -2.07,2.49 -3.69,2.19 -1.1,0.14 -2.28,0.47 -3.22,-0.34 -0.92,-0.56 -2.13,0.68 -2.94,-0.16 0.01,-0.83 -0.61,-1.31 -1.38,-1.38 -0.78,-0.8 -1.79,-1.41 -2.34,0.03 -0.59,0.79 -1.23,2.07 -2.44,1.53 -1.04,-0.18 -2.28,-1.4 -3.16,-0.25 -0.9,0.21 -2.02,-0.57 -2.56,-1.19 -0.7,-0.78 -2.02,-0.47 -2.69,-1.41 -0.96,-0.59 -1.07,-1.66 -1.5,-2.56 -0.57,-1.01 -1.73,-1.1 -2.69,-1.38 -0.97,-0.69 -0.43,-2.87 -2.16,-2.34 -1.83,0.27 -3.51,-0.98 -5.31,-0.16 -1.83,0.82 -3.71,-0.31 -5.03,-1.5 -0.59,-2.25 -0.45,-4.68 -1.31,-6.84 0.06,-0.87 -0.25,-2.01 -1.38,-1.78 -1.32,-0.47 -2.58,-1.19 -3.91,-1.63 -1.03,-1.53 -1.41,-3.72 -3.16,-4.69 -0.04,-0.8 -0.53,-1.53 -1.44,-1.38 -2.98,-0.8 -3.59,-4.26 -5.66,-6.19 -1.22,-1.39 -3.1,-2.33 -3.75,-4.09 0.95,-0.72 -0.84,-1.59 -0.97,-2.41 0.12,-1.71 2.35,-0.96 3.47,-1.22 1.56,-0.36 2.28,-2.51 4.13,-2 1.07,0.21 1.45,-0.79 1.38,-1.66 0.5,-1.47 1.43,-2.81 2.09,-4.19 1.14,-0.7 2.71,-0.86 4,-0.59 1.84,1.54 4.43,0.75 6.63,0.91 1,0.15 1.4,-0.71 1.47,-1.53 0.46,-1.27 2.13,-1.71 2.25,-3.13 0.57,-0.99 2.45,-0.1 2.53,-1.56 0.32,-0.69 1.89,-1.52 0.69,-2.06 -1.49,0.33 -2.05,-1.8 -3.63,-1.38 -1.04,0.07 -2.8,1.05 -3.28,-0.44 -0.23,-1.01 -0.72,-2.17 -1.94,-2.09 -1.66,-0.43 -2.33,-2.14 -2.16,-3.72 0.26,-0.84 -0.67,-2.55 0.66,-2.75 1.54,-0.13 2.47,-1.35 3.22,-2.56 0.93,-0.95 2.84,-2.22 4.03,-1.06 0.35,0.98 1.21,1.31 2,1.78 0.75,1.22 1.95,1.36 2.72,0.03 1.24,-1.28 3.37,-1.22 4.44,-2.75 0.82,-0.56 1.96,-1.49 2.97,-1.13 1.17,0.86 2.76,-0.14 4.09,0.06 1.04,-0.75 0.22,-2.48 0.53,-3.66 -0.06,-2.8 3.34,-3.41 4.69,-5.38 0.98,-1.38 1.08,-3.08 1.91,-4.56 0.41,-1.38 -0.35,-2.81 -0.13,-4.25 0.19,-1.4 -0.47,-3.44 1.13,-4.19 0.69,-0.47 1.86,-0.41 1.84,-1.53 0.36,-1.32 -0.29,-2.73 0.47,-3.97 -0.18,-2.87 2.37,-4.86 4.09,-6.78 1.2,-1.18 3.69,0.31 4.84,-1.28 0.25,-1.14 1.68,-0.39 2.13,-1.38 1.24,-2.23 3.08,-4.07 4.41,-6.25 1.21,-1.61 2.7,-2.88 4.63,-3.5 2.21,-1.26 4.23,-2.94 6.69,-3.72 2.01,-1.06 4.32,-2 5.72,-3.84 0.15,-1.87 -2.07,-2.68 -3.63,-2.72 -1.12,0.03 -1.93,-0.58 -2.69,-1.34 -0.86,-0.77 -2.04,-0.53 -3,-0.69 -1.1,-0.6 -1.68,-2.01 -3.09,-1.91 -0.73,-0.89 -2.25,0.06 -3,-0.5 0.21,-1.15 -0.14,-2.3 -0.97,-3.16 -0.34,-0.62 0.58,-1.4 -0.19,-1.97 -1.34,-1.45 -3.48,-1.63 -5.03,-2.72 -1.8,-0.25 -3.46,-1.15 -5.34,-1.09 -0.13,-0.05 -0.26,-0.06 -0.38,-0.03 z M 30.43,745.38 c -1.25,0.29 -2.01,1.55 -3.34,1.75 -1.94,0.64 -1.51,3.3 -0.53,4.59 0.65,0.86 1.05,2.23 -0.03,2.94 -0.9,0.48 -2.06,1.09 -1.59,2.34 -0.12,0.89 0.06,2.72 1.38,2.09 0.67,0.06 1.79,-0.28 1.25,-1.16 -0.5,-0.48 -0.61,-1.19 0.13,-1.41 0.76,-0.03 2.41,0.19 2.09,-1.06 -0.28,-0.43 -1.4,-0.97 -0.78,-1.56 0.78,-0.23 0.21,-1.51 1.16,-1.34 0.74,0.02 2.57,0.03 1.94,-1.19 -0.48,-0.38 -0.72,-1.87 0.22,-1.47 0.62,1.08 1.01,2.65 2.53,2.63 1.04,0.22 0.75,-1.23 1.66,-1.38 0.93,-0.29 1.62,-2.2 0.16,-2.09 -0.73,0.01 -1.06,1.32 -1.78,0.91 0.05,-0.76 0.29,-1.94 -0.81,-2.06 -1.05,-0.13 -1.58,-1.13 -1.94,-1.97 -0.44,-0.42 -1.08,-0.62 -1.69,-0.56 z m -5.81,16 c -1.65,0.39 -2.14,2.17 -1.94,3.66 0.08,0.89 -0.72,2.03 0.44,2.5 0.76,0.53 2.63,1.41 2.88,-0.06 -0.03,-1.26 -2.41,-1.19 -1.72,-2.66 0.57,-0.94 2.02,-2.32 0.91,-3.38 -0.17,-0.09 -0.37,-0.09 -0.56,-0.06 z m 1.94,14.84 c -1.36,0.27 -1.77,1.85 -2.84,2.44 -0.99,0.21 -2.57,0.6 -3.16,-0.44 -0.93,-0.51 -2.25,-0.14 -2.38,1 -0.26,0.91 -2.01,1.98 -0.91,2.72 1.63,0.29 3.31,0.3 4.84,-0.31 0.85,0.56 1.83,1.51 2.66,0.34 1.07,-0.93 2.6,0.37 3.06,1.41 0.2,0.99 -0.54,2.01 -0.41,3.06 -0.33,0.75 0.18,2.29 1.09,1.41 1.17,-0.65 1.42,0.97 2.19,1.47 0.89,0.47 0.33,1.54 1.13,2.09 0.54,0.63 1.85,1.8 2.44,0.63 0.57,-1 0.49,-2.38 -0.72,-2.78 -0.23,-0.81 1.05,-1.33 0.97,-2.22 0.34,-0.99 -0.02,-2.27 -1.22,-2.28 -0.64,-0.3 0.28,-1.29 0.16,-1.84 0.21,-1.01 -0.33,-2.13 -0.16,-3.06 1.35,-0.23 1.48,-2.08 0.28,-2.66 -0.59,-0.62 -1.79,-0.82 -2,0.19 -1.33,0.15 -2.94,0.36 -3.88,-0.81 -0.34,-0.21 -0.75,-0.4 -1.16,-0.34 z m 13.84,7.72 c -1.34,-0.03 -3.39,0.62 -2.94,2.34 0.31,0.86 -0.75,1.3 -0.72,2.13 -1.09,0.59 -1.17,1.92 -0.53,2.88 -0.33,0.79 -1.02,2.09 0.25,2.47 1.8,0.65 3.71,0.03 5.38,-0.66 1.42,-0.46 2.37,-1.81 3.13,-2.91 0.03,-1 -1.33,-1.02 -1.44,-2.03 -1.25,-1.27 0.46,-1.7 0.38,-2.78 -0.94,-0.25 -2.03,-0.35 -2.56,-1.28 -0.28,-0.19 -0.61,-0.18 -0.94,-0.16 z m 12.63,77.56 c -0.13,-0.01 -0.28,0.06 -0.44,0.19 -0.12,1.09 -2.39,0.79 -1.69,2.13 0.38,0.19 0.71,0.53 0.16,0.78 -1.31,0.65 -0.09,2.25 1.03,2.09 0.97,1.22 2.35,-0.41 2.44,-1.47 0.32,-1.03 -0.28,-1.98 -0.81,-2.75 -0.06,-0.4 -0.3,-0.94 -0.69,-0.97 z m 4.88,0.47 c -0.09,7.1e-4 -0.19,0.03 -0.28,0.06 -1.18,0.51 -2.36,2.54 -1.06,3.47 1.33,0.24 2.66,-0.84 2.34,-2.25 -0.01,-0.55 -0.4,-1.29 -1,-1.28 z",
						"nir" : "m 266.65,636.53 c -1.23,0.88 -2.57,1.74 -3.09,3.22 -0.91,1.19 -2.6,0.66 -3.72,1.54 -1.65,0.56 -3.54,0.17 -5.08,1.11 -1.68,0.33 -3.9,0.98 -4.01,3.08 -0.3,1.03 1.28,1.07 1.28,1.85 -1.02,0.51 -2.22,-0.71 -3.37,-0.35 -0.9,-0.24 -1.48,-1.28 -2.56,-0.99 -3.47,0.3 -7.57,0.54 -9.98,-2.47 -1.36,-0.67 -0.79,1.37 -1,2.16 -0.13,2.11 -1.05,4.01 -1.59,5.97 -0.19,0.53 1.22,1.23 0.26,1.37 -1.09,-2.7e-4 -3.04,0.32 -2.63,1.87 0.54,0.76 0.49,1.69 -0.24,2.31 -0.83,0.61 -0.54,2.02 -1.67,2.23 -1.98,0.56 -4.16,1.27 -6.22,0.76 -0.92,-0.38 -0.96,-1.83 -2.18,-1.82 -1.27,0 -3.11,-0.04 -3.83,1.2 0.15,0.75 -0.47,1.09 -1.13,0.81 -1.52,0.04 -2.39,1.83 -2.76,3.1 -0.21,1.11 -1.99,1.08 -1.84,2.44 -0.15,1.2 -1.86,1.25 -2.24,2.39 -0.83,1.59 -2.18,3 -3.77,3.84 -1.08,-0.21 -3.2,0.15 -2.67,1.7 0.56,1.38 -0.54,2.97 0.42,4.28 0.26,1.99 -1.4,3.69 -1.78,5.61 -0.65,2.08 -2.59,3.2 -4.33,4.26 -1.68,1.67 -0.52,4.25 -0.48,6.29 -0.24,1.56 -2.19,1.01 -3.25,0.9 -1.43,0.1 -2.84,-0.24 -4.23,-0.29 -1.43,0.8 -2.61,2.11 -4.26,2.54 -1.49,0.61 -2.16,2.56 -4.02,2.32 -1.3,0.2 -1.77,-1.62 -3.05,-1.74 -0.82,-0.31 -0.97,-1.92 -2.1,-1.27 -1.31,0.84 -1.6,2.75 -3.07,3.37 -0.42,0.93 -1.32,2.53 -0.28,3.32 1.21,0.08 2.8,0.69 2.87,2.11 0.63,1.15 1.76,-0.07 2.58,-0.06 1.17,0.42 2.06,1.23 3.03,1.9 1.35,0.42 2.53,-0.72 3.76,-0.83 1.28,0.59 1.89,2.51 1.32,3.72 -1.62,0.88 -3.77,1.05 -4.78,2.8 -1.44,0.96 -3.26,1.88 -3.81,3.64 0.23,1.63 -1.75,2.62 -3.17,2.42 -2.52,-0.01 -5.2,0.44 -7.5,-0.82 -2.06,-0.45 -3.1,2 -3.73,3.53 -0.21,0.91 -0.07,2.78 -1.48,2.55 -0.9,-0.04 -1.89,0.03 -2.42,0.82 -1.3,0.83 -3.58,1.58 -3.16,3.54 1.34,1.83 3.28,3.21 4.48,5.19 0.78,1.26 1.38,3.05 3.15,3.17 1.08,-0.24 2.49,0.11 2.45,1.44 0.66,1.61 1.72,3.04 2.46,4.61 1.21,1.11 3.03,0.76 4.45,1.11 0.62,0.97 1.77,1.75 1.52,3.07 0.28,1.98 0.76,3.89 0.82,5.92 0.2,2.07 2.82,1.89 4.3,1.53 1.92,-0.53 3.72,0.73 5.66,0.19 0.72,-0.11 2.16,-0.41 1.77,0.86 0.02,1.44 1.9,1.44 2.51,2.54 1.12,0.86 1.48,2.21 2.19,3.32 0.77,0.88 2.26,0.46 2.88,1.59 0.67,0.73 1.14,-0.56 1.91,-0.15 1.26,-0.02 2.63,1.92 3.51,0.29 1.2,-1.51 3.31,-3.15 5.31,-2.37 0.48,0.73 1.3,0.93 2.03,1.28 0.77,0.28 0.85,2.08 1.83,1.18 0.12,-1.47 1,-2.91 1.96,-3.96 1.21,-0.4 3.27,0.12 3.13,-1.77 0.25,-1.23 0.59,-3.09 2.17,-3.06 1.32,-0.3 2.23,-1.63 3.51,-1.86 0.44,0.52 1.45,0.39 1.27,-0.46 -0.5,-1.18 0.92,-2.69 -0.42,-3.54 -1.24,-0.09 -1.52,-1.38 -2.13,-2.2 -1.15,-0.69 -1.37,-2.65 0.08,-3.1 2.01,-0.56 -1.01,-2.7 0.58,-3.41 0.79,-0.95 1.85,0.54 2.72,-0.3 1.09,-0.59 2.08,-1.41 2.39,-2.61 0.78,-1.48 2.33,-2.3 2.84,-3.96 0.49,-1.3 1.77,-2.96 3.32,-2.59 1.05,0.66 2.17,1.29 3.38,1.55 1.55,1.23 2.84,2.83 4.41,4 0.44,1.07 1.12,2.04 2.19,2.54 1.18,2.03 1.63,4.47 2.15,6.78 0.12,0.98 -1.71,2.47 -0.07,2.68 0.93,-0.06 2.12,0.73 1.66,1.78 -0.26,1.05 0.81,1.59 0.91,2.57 0.59,1.52 1.65,3.08 3.28,3.48 0.56,0.47 1.7,1.74 2.23,0.53 0.56,-1.08 1.89,-1.09 2.81,-0.45 1.71,0.83 3.17,2.44 3.65,4.31 0.17,1.21 0.12,2.46 -0.47,3.5 -0.3,0.95 -1.42,1.83 -0.79,2.92 0.82,1.37 -0.51,2.57 -0.46,3.92 0.28,0.91 1.14,1.46 1.49,2.34 1.13,0.8 1.74,-1.22 2.97,-0.78 1.72,0.13 3.42,-0.33 5.02,-0.82 1.21,-0.77 2.92,-2.07 4.31,-0.9 1.16,1.28 3.11,0.35 4.27,-0.44 0.72,-1.27 -0.75,-3.12 0.3,-4.25 1.1,-0.63 2.44,-0.46 3.38,0.34 1.12,0.43 1.65,-0.99 1.01,-1.77 -0.32,-1.67 -2.03,-2.88 -1.92,-4.61 0.33,-0.33 0.88,0.74 1.14,0.99 1.61,2.28 2.44,5.86 5.62,6.39 1.31,0.11 3.55,-0.23 3.76,1.61 0.47,1.73 2.39,3.02 4.12,2.18 0.73,0.36 1.57,0.43 2.29,0.78 0.53,0.38 1.45,1.36 1.03,1.99 -0.99,-0.04 -1.02,1.3 -0.05,1.35 1.87,0.77 3.42,-0.99 4.45,-2.31 0.9,-1.12 2.76,-0.75 3.22,-2.28 1.25,-2.03 4.43,-2.74 4.48,-5.46 -0.14,-2.57 2.1,-4.92 0.92,-7.46 -0.64,-1.07 -1.39,-2.62 -0.15,-3.57 0.69,-0.84 2.52,-1.95 1.48,-3.12 -0.01,-1.09 1.38,-1.62 1.69,-2.63 0.43,-0.49 0.68,-1.87 1.43,-1.82 0.49,0.78 -0.42,1.86 0.22,2.69 -0.28,0.64 -0.39,1.61 0.65,1.51 2.12,0.23 3.93,-1.31 6.03,-0.79 1.29,0.04 2.86,0.39 3.14,1.9 0.61,1.04 1.6,-0.2 1.4,-1.01 -0.04,-0.73 -0.41,-1.86 0.74,-1.77 0.67,0.56 1.41,0.11 1.82,-0.5 2.08,-0.45 3.04,-2.69 3.71,-4.5 1.18,-1.4 0.03,-3.37 -0.03,-4.96 0.01,-0.92 -0.57,-1.48 -1.28,-1.86 -0.67,-0.38 -0.77,-1.93 -1.79,-1.23 -0.65,0.34 -1.56,-0.03 -2.06,0.7 -0.81,0.13 -1.1,1.12 -2.06,0.97 -1.19,0.02 -1.87,1.25 -2.84,1.57 -0.85,-0.86 0.69,-1.57 0.8,-2.45 0.77,-1.41 2.84,-2.26 2.77,-4.02 -0.74,-1.85 1.26,-4.03 -0.29,-5.62 0.25,-0.8 -0.65,-1.45 -0.18,-2.28 0.35,-1.62 -2.29,-1.98 -1.63,-3.64 0.31,-1.78 -1.22,-3.12 -2.84,-3.4 -0.24,-0.98 1.78,-1.14 1.47,-2.38 -0.01,-1.12 0.14,-3.01 1.47,-3.26 1.06,0.28 1.47,1.58 2.55,1.86 0.86,0.81 2.23,0.73 2.88,1.87 0.56,1.03 1.36,2.02 2.64,1.91 0.9,1.19 0.73,2.94 1.45,4.26 0.34,0.89 0.96,1.73 0.47,2.66 0.05,1.88 0.46,4.13 -0.52,5.77 -1.3,-0.38 -2.6,0.76 -2.4,2.1 0.46,1.67 2.08,2.72 2.65,4.37 0.67,0.56 0.6,1.35 0.81,2.11 0.65,1.02 1.9,-0.04 1.76,-0.98 0.24,-1.19 0.03,-3.2 1.61,-3.4 1.03,-1.54 -0.39,-3.3 -0.7,-4.82 0.39,-1.09 1.85,-1.33 2.09,-2.59 0.56,-1.44 1.17,-3.78 -0.61,-4.6 -0.79,-1.44 -0.93,-3.17 -1.64,-4.66 -0.4,-1.16 0.07,-2.33 0.14,-3.44 -0.52,-1.04 -1.51,-1.79 -1.93,-2.87 -1.12,-0.64 -1.04,-2.18 -1.63,-3.18 0.04,-1.76 -0.26,-3.65 -1.84,-4.71 -0.66,-0.74 -1.07,-1.87 -2.29,-1.73 -0.88,-0.09 -2.08,-0.23 -2.42,0.74 -0.87,0.43 -1.96,0.32 -2.83,0.68 -1.32,-0.65 -2.93,-0.06 -4.15,-0.99 -1.93,-0.01 -3.74,1.2 -5.32,2.19 -1.28,1.03 -2.51,2.1 -3.74,3.14 -0.44,0.82 -1.35,0.83 -1.96,1.33 -0.19,0.78 -1.08,1.62 -1.73,1.79 -0.32,-2.76 0.56,-5.38 1.74,-7.82 0.43,-1.69 2.11,-2.74 3.17,-4.05 1.21,-1.52 3.23,-1.87 4.87,-2.69 1.32,-0.24 2.55,-0.75 3.42,-1.84 2.34,-1.8 2.64,-5.02 2.2,-7.73 -0.7,-1.88 -1.49,-4.53 -3.74,-4.97 -1.13,-0.16 -1.83,1.37 -0.74,1.96 0.72,0.43 1.31,0.92 1.55,1.71 1.15,1.23 1.91,3.08 1.58,4.77 -0.08,0.6 -0.6,0.63 -0.75,0.02 -0.82,-1.35 -1.33,-3.15 -2.55,-4.11 -1.12,-0.07 -2.43,-0.61 -3.13,-1.5 -0.36,-0.9 -0.62,-2.18 0.22,-2.86 0.49,-1.88 -2.13,-2.43 -2.29,-4.17 -0.28,-1.14 -1.7,-0.79 -2.16,-1.82 -1.49,-2.1 -1.74,-5.06 -3.81,-6.77 -0.75,-0.46 -1.91,-0.01 -2.15,-1.11 -0.56,-0.5 -1.55,-0.23 -1.86,-1.11 -0.08,-1.9 1.26,-3.52 1.31,-5.45 0.45,-0.93 0.47,-2.28 -0.78,-2.53 -1.28,-0.46 -2.66,0.04 -3.89,0.2 -0.82,-0.34 -1.55,-1.04 -1.18,-2.02 -0.04,-2 1.59,-3.68 1.31,-5.7 -0.35,-0.47 -0.66,-0.95 -0.24,-1.55 1.27,-1.34 1,-3.55 -0.52,-4.57 -0.66,-1.69 -2.07,-3.23 -3.83,-3.87 -1.39,-0.06 -1.73,-2.38 -3.07,-2.08 -1.4,1.46 -3.52,2.2 -5.43,2.53 -1.52,-0.88 -2.88,-1.98 -4.47,-2.74 -1.69,-0.31 -3.33,-2.06 -5.13,-1.19 -0.75,0.54 -1.62,1.18 -2.56,0.54 -1.17,-0.42 -2.66,-0.22 -3.38,-1.46 -0.25,-0.3 -0.63,-0.75 -1.06,-0.48 z",
						"imn" : "m 407.92,731.85 c -1.8,0.94 -3.78,1.34 -5.67,2.02 -2.14,1.36 -4.59,2.75 -5.79,5.07 -0.74,2.73 -2.25,5.25 -3.2,7.93 -1.65,3.06 -4.3,5.59 -7.36,7.19 -0.81,1.38 -0.38,3.32 -1.33,4.71 -0.8,0.74 -0.57,1.75 -0.23,2.63 0.26,1.89 -0.39,3.82 -1.27,5.43 -0.78,-0.01 -2.1,0.84 -1.05,1.55 0.74,0.26 0.58,1.11 -0.1,1.35 -0.63,0.39 -1.67,1.85 -0.41,2.05 1.53,-0.37 2.12,-2.38 3.59,-2.76 0.88,0.15 1.94,0.03 2.32,1.07 0.74,1.74 2.16,-0.15 3.4,-0.15 1.66,-0.78 2.63,-2.96 4.69,-2.83 1.34,-0.25 1.46,-1.87 2.35,-2.57 1.24,-0.44 3.28,-0.7 3.2,-2.45 -0.45,-1.54 1.12,-2.59 2.45,-2.62 1.29,-0.54 2.66,-1.56 3.2,-2.88 -0.26,-0.77 -0.99,-1.53 -0.5,-2.43 0.29,-1.26 2.12,-1.48 1.99,-2.93 0.32,-1.31 1.63,-2.03 1.98,-3.31 0.72,-0.6 0.61,-1.69 1.02,-2.34 1.03,-0.97 -0.84,-1.53 -1.55,-1.69 -1.93,-0.33 -2.38,-2.54 -2.47,-4.17 0.33,-2.51 1.85,-5.03 1.39,-7.59 -0.11,-0.25 -0.4,-0.36 -0.66,-0.28 z",
						"wls" : "m 404.34,844.34 c -1.13,0.14 -0.99,1.98 -2.41,1.47 -2.25,0.32 -4.41,1.01 -6.63,1.28 -0.68,0.79 0.61,1.42 0.38,2.31 0.89,2.55 -1.96,5.55 0.28,7.84 1.19,0.44 0.62,1.6 -0.22,2.06 -1.76,0.64 -1.33,1.82 -0.06,2.56 0.73,1.32 0.75,3.02 2.22,3.94 0.28,1.08 1.12,1.84 1.59,2.81 0.1,1.31 0.06,3.3 1.97,3.03 1.47,-0.18 1.18,2.92 2.91,1.91 0.88,-0.75 1.43,-2.95 2.91,-2.53 0.62,1.03 0.47,2.89 -0.97,3.03 -1.45,0.85 -0.11,2.28 1.03,2.53 1.1,1.05 2.39,0.47 2.94,-0.66 1.5,-0.09 3.03,-0.53 3.94,-1.88 1.27,-1.63 4.33,-2.09 4.22,-4.59 1.33,-2.41 4.45,-3.1 6.28,-5.16 1.34,-0.99 2.4,-2.2 2.88,-3.78 0.42,-0.85 2.14,-2.75 0.38,-3.09 -1.54,-0.27 -3.82,-0.98 -4.63,0.88 -1.35,0.41 -2.85,0.93 -4.28,1.19 -1.22,-0.66 -0.29,-2.45 -1.16,-3.44 -1,-1.12 -0.59,-2.74 -1.44,-3.81 -1.11,0.22 -1.86,-1.19 -3,-0.75 -0.12,-1.6 1.51,-3.23 0.28,-4.78 -1.23,-1.81 -3.86,-0.44 -5.44,-1.13 -0.56,-1.57 -2.5,0.13 -3.13,-1.13 -0.19,-0.1 -0.42,-0.15 -0.63,-0.13 -0.09,-0.01 -0.14,-0.01 -0.22,0 z m 74.13,8.44 c -0.07,-0 -0.15,0.02 -0.22,0.03 -4.79,0.73 -8.96,3.47 -13.34,5.31 -2.71,0.58 -5.24,2.2 -8.16,1.63 -1.86,-0.33 -4.48,0.19 -5.88,-1.22 -1.17,-2.18 -4.36,-2.43 -6.56,-2.06 -1.22,1.33 0.71,3.2 1.72,4.09 1.2,0.32 0.78,2.11 0.25,2.84 -1.2,0.92 1.11,2.98 -0.69,3.19 -0.55,-0.85 -1.5,-2.35 -0.88,-3.19 1.44,-1.34 -0.91,-3.73 -2.56,-3.25 -2.28,0.48 -3.87,2.51 -6.22,2.84 -2.89,1.34 -5.54,3.98 -8.84,3.94 -2.57,-1.28 -4.79,1.21 -6.94,2.19 -1.53,0.83 -0.48,3.01 -2.06,3.91 -1.77,2.32 -4.82,3.93 -5.72,6.84 0.16,1.27 -0.65,2.03 -1.44,2.78 -0.76,2.51 0.08,5.61 -2.28,7.47 -1.45,1.52 -2.73,3.38 -4.78,4.03 -1.51,1.26 -2.25,3.2 -3.88,4.44 -1.08,1.58 -2.86,1.85 -4.63,1.84 -1.23,0.6 -2.48,1.26 -3.56,2.06 -0.5,1.72 -3.19,2.08 -3.09,4.19 -1.04,1.05 -1.76,2.45 -3.13,3.13 -0.71,1.26 -1.05,2.78 -2.06,3.94 -0.43,0.77 -1.61,2.69 -0.13,3 1.17,-0.23 0.99,-2.21 2.47,-1.78 2.03,-0.02 4.95,0.57 5.81,-1.91 1.03,-1.56 2.97,0.25 4.03,0.88 1.08,1.01 2.66,3.07 4.28,1.75 0.22,-0.95 -1.29,-1.38 -0.91,-2.47 0.05,-1.64 1.3,-2.91 1.78,-4.41 0.94,-1.52 2.7,-1.86 4,-2.78 1.22,-1.68 3.52,-1.65 5.41,-1.5 0.97,-0.13 0.76,-1.55 1.97,-1.41 2.18,-0.17 4.31,-1.07 6.47,-1 1.69,0.43 4.35,1.98 5.41,-0.28 0.35,-1.37 1.89,-0.54 2.72,-0.16 0.82,0.32 2.37,-0.52 2.84,0.03 -0.36,1.03 -1.75,1.5 -1.91,2.59 -1.1,1.13 -2.92,0.47 -4,1.34 0.06,1.68 1.77,3 1.72,4.81 0.5,1.7 -0.47,3.22 -1.59,4.41 0.79,2.41 2.95,4.41 4.06,6.78 0.59,0.94 1.64,3.5 3,2.19 0.37,-1.56 2.45,-1.06 3.47,-2.03 0.8,-0.28 2.73,-1.58 3.25,-0.34 0.05,0.94 -1.62,0.25 -2.06,1 -1.56,0.54 -2.15,2.33 -3.38,3.13 -2.27,0.75 -2.57,3.37 -4.28,4.75 -1.27,1.94 -3.08,4.21 -2.84,6.56 0.45,0.77 2.63,0.31 2.22,1.56 -1.62,1.62 0.61,3.82 1.03,5.5 0.81,1.89 3.28,0.24 4.69,0.09 1.22,-0.06 2.66,-1.4 3.78,-1 0.89,0.75 -1.16,1.54 -1.47,2.16 -1.4,1.39 -3.04,2.97 -5.25,2.44 -1.13,1.13 0.07,3.32 -0.59,4.88 -1.17,2.46 -1.54,5.2 -1.91,7.88 -0.62,2.73 -2.24,5.12 -2.63,7.91 -0.81,2.02 -2.13,3.79 -3.19,5.66 -1.6,2.31 -3.36,4.48 -5.94,5.69 -2.12,1.27 -4.09,4 -6.78,3.75 -1.52,-0.71 -2.52,1.6 -3.53,2.38 -1.6,2.2 -4.24,3.04 -5.75,5.34 -1.27,1.11 -3.11,1.19 -4.63,0.59 -2.11,-0.41 -4.17,-0.02 -6.13,0.66 -1.77,-0.02 -2.31,2.06 -1,3.06 0.16,0.63 0.06,2.02 -0.56,2.09 -0.38,-1.39 -1.76,-3.25 -3.44,-2.56 -0.62,1.13 -0.67,2.6 -1.72,3.59 -0.97,1.38 -2.4,2.54 -4.16,2.59 -1.57,0.77 -0.19,2.49 -0.13,3.53 -1.61,0.31 -3.65,0.54 -5,-0.38 -1.33,0.04 -0.38,2.11 -1.78,1.84 -1.06,0.62 -3.16,1.73 -3.75,0 -0.37,-1.6 -2.05,-1.17 -3.13,-1.47 -0.8,-0.57 -3.29,-1.04 -3.16,0.47 0.63,0.75 0.85,1.44 0.03,2.09 -0.75,0.98 0.38,3.07 -1.03,3.47 -0.79,0.32 -1.28,1.05 -2.28,1.03 -1.15,0.57 -2.19,1.38 -3.59,1.19 -1.57,0.27 -1.98,2.37 -3.69,2.34 -0.89,1.36 -2.75,1.53 -4,2.38 -0.19,0.87 0.08,1.73 -0.63,2.44 -0.58,1.33 0.92,1.99 1.91,1.25 2.89,-0.5 5.79,-0.03 8.53,0.84 2.58,0.52 2.12,3.85 3,5.72 0.17,1.71 0.49,4.17 -1,5.38 -1.16,0.46 -3.03,-0.73 -3.63,0.81 -1.93,0.87 -3.11,3.62 -1.44,5.28 1.2,0.66 1.23,-1.88 1.84,-1.69 0.41,1.55 3.39,1.81 3.69,0.13 1.38,0.33 2.06,2.45 3.81,1.63 2.03,-0.26 3.8,1.79 5.84,0.66 0.79,-0.34 3.19,-1.06 2.47,0.66 -0.98,0.66 -0.73,1.88 0.38,2.22 0.86,1.03 -1.28,1.14 -1.88,1.13 -1.54,0.29 -2.63,-0.62 -3.75,-1.44 -0.96,-0.61 -2.24,-0.22 -2.19,0.97 -0.8,0.28 -2.03,0.8 -1.25,1.88 1.17,1.4 -0.43,4.02 1.63,4.72 2.05,0.68 4.21,0.75 6.09,1.97 1.39,0.53 0.79,-1.49 1.97,-1.63 1.15,-1.91 3.16,-4.15 5.69,-3.63 1.44,0.48 3.88,1.02 4.5,-0.75 1.28,-0.06 3,0.27 3.06,-1.47 0.91,-1.79 0.97,-3.76 0.97,-5.66 1.49,-2.98 5.62,-2.36 8.38,-2.84 2.82,-0.7 5.8,1.3 8.5,0.22 1.24,-0.62 0.2,-1.75 -0.72,-1.97 -0.9,-0.65 -0.67,-1.69 -0.22,-2.47 0.01,-0.62 -1.53,-1.14 -0.34,-1.44 1.95,-0.29 1.76,2.15 2.91,2.97 2.65,0.6 2.96,-5.07 5.63,-3.78 -1.25,1.51 -2.69,3.81 -2.22,5.94 1.16,1.02 3.44,0.51 4.09,2.22 -0.87,1.56 -3.5,-1.18 -3.97,0.81 0.93,2.13 2.67,4.21 4.75,5.31 1.18,0.32 1.63,-1.35 2.94,-0.81 1.3,-0.03 2.3,-1.16 3.66,-0.56 2.19,0.36 3.39,3.69 6,2.53 0.81,-0.86 2.62,-0.29 2.38,0.84 -0.98,0.44 -2.04,0.7 -2.69,1.59 -0.93,0.43 -1.89,1 -2.38,1.81 -2.96,1.33 -7.04,-1.1 -9.34,1.91 -0.87,1.28 0.55,2.73 0.31,4.16 0.53,1.74 2.53,2.95 4.25,3.19 1.02,-0.55 2.17,-0.49 3.28,-0.53 0.74,-0.55 0.41,-1.79 1.53,-2.09 1.83,-1.4 3.71,0.66 5.59,0.44 1.15,-0.7 2.49,-0.64 3.75,-0.69 0.97,-1.01 0.35,-3.04 1.78,-3.84 3.02,-2.15 7.09,-1.38 10.38,-2.84 -0.38,1.99 0.67,4.63 3.03,4.34 0.98,0.19 0.53,1.32 0.19,1.78 0.81,2.7 1.94,5.32 2.84,8 0.81,0.93 1.12,2.24 2.03,3.03 1.54,0.38 4.27,-0.98 4.91,1.16 1.11,2.16 3.91,3.19 4.41,5.66 1.28,2.69 4.49,1.98 6.81,2.78 3.18,0.47 6.58,1.7 9.75,0.75 1.83,-1.28 4.32,0.05 6.06,-1.53 1.27,-0.77 3.51,0.82 4.03,-1.13 0.51,-1.51 -0.11,-3.54 0.63,-4.81 1.34,-0.26 1.64,-1.54 1.84,-2.63 0.45,-1.25 1.48,-2.03 2.72,-2.31 2.03,-1.73 4.6,-2.79 6.5,-4.66 0.67,-1.01 0.81,-2.47 1.38,-3.41 0.85,0.12 2.06,1.37 1.09,2.13 -0.18,1.7 2.33,1.01 3.34,1.09 3.2,0.03 5.71,-1.99 8.28,-3.56 1.46,-1.02 3.31,-1.05 4.81,-1.81 0.93,-1.29 2.08,-2.33 3.19,-3.44 0.32,-2.1 -1.81,-3.95 -1.31,-6.09 1.35,-0.61 1.07,-2.43 0.31,-3.34 0.22,-1.71 -1.07,-3.71 0.56,-5.03 0.65,-1.28 -0.87,-2.38 -0.53,-3.75 -0.17,-1.83 -0.03,-3.64 1.09,-5.13 0.61,-1.24 -0.97,-1.38 -1.81,-1.13 -1.53,-0.88 -3.97,-0.06 -4.78,-2.13 -1.15,-1.5 -1.23,-3.55 -2.91,-4.69 -1.11,-0.94 -2.19,-2.26 -3.72,-2.44 0.27,-1.75 -1.76,-1.54 -2.66,-0.72 -1.43,0.54 -2.93,2.15 -4.53,1.69 -0.32,-0.81 -0.61,-2.18 -1.81,-1.75 -1.56,-0.31 -1.12,-2.4 -2.25,-3.28 -2.25,-2.96 -4.75,-6.3 -4.19,-10.28 -0.15,-2.04 -2.84,-3.17 -2.03,-5.44 0.11,-1.33 1.3,-2.98 -0.22,-4 -0.94,-0.55 -0.91,-2.15 0.44,-2.03 2.22,0.34 1.29,-1.17 0.16,-1.81 -0.87,-1.54 1.69,-2.41 1.25,-4.09 0.29,-1.76 1.71,-3.11 1.84,-4.94 1.23,-0.25 1,-2.1 2.38,-2.25 2.68,-0.37 1.35,-3.51 1.81,-5.38 -0.5,-2.21 2.43,-2.55 2.84,-4.28 -0.62,-1.91 -3.08,-0.4 -4.41,-0.31 -3.19,0.41 -4.74,-3.07 -7.22,-4.41 -1.53,-1.82 -3.73,-2.8 -5.53,-4.25 -1.81,-2.57 0.18,-6.09 2.94,-6.91 2.58,-1.6 5.45,-2.45 8.47,-2.41 1.34,-0.34 0.43,-2.65 2,-2.81 1.71,-0.64 1.54,-3.26 1.03,-4.69 -1.42,-0.8 -2.76,1.2 -3.81,1.94 -0.88,1.07 -1.38,2.42 -2.94,2.72 -0.78,0.65 -2.55,0.15 -1.78,-1 1.58,-1.07 0.52,-2.79 -0.09,-4.03 -0.28,-1.06 -0.16,-2.37 1.19,-2.47 2.37,-1.08 2.25,-3.93 2.69,-6.06 2.13,-0.89 2.15,-3.48 1.84,-5.47 0.3,-0.81 1.58,-1.16 1.47,-2.34 -0.3,-1.53 2.46,-1.48 1.56,-3.09 -1.31,-0.59 -1.38,-2.54 -3,-2.69 -1.11,-0.15 -2.57,-0.14 -2.47,-1.59 -0.82,-1.1 -2.51,-0.19 -3.59,-1 -2.18,-0.45 -1.48,-3.3 -1.38,-4.88 0.16,-1.28 -0.03,-2.69 1.19,-3.5 0.5,-1.12 -1.11,-2.28 -0.13,-3.44 0.5,-0.92 2.16,-0.85 1.97,-2.22 0.13,-1.5 1.47,-3.07 3.09,-2.31 2.79,0.32 3.34,-3.18 5.59,-4.03 0.84,-0.81 1.53,-0.29 1.72,0.69 0.78,1.64 3.02,2.05 4.28,0.72 0.92,-0.31 1.86,0.62 2.81,0.69 1.71,1.11 2.71,2.92 3.75,4.56 1.45,-0.69 2.48,-2.29 4.06,-2.81 0.88,-1.52 1.52,-3.5 1.28,-5.25 -1.16,-0.95 -2.88,-0.76 -4.25,-1.31 -1.8,0.27 -4.03,-0.37 -4.34,-2.41 -0.84,-0.9 -1.68,-1.8 -1.34,-3.19 0.27,-1.51 -0.52,-2.7 -1.34,-3.81 -0.06,-0.87 -0.5,-1.62 -1.13,-2.13 -0.22,-0.81 1.44,-1.94 -0.13,-2.19 -2.41,-0.4 -4.18,-2.57 -5.59,-4.38 -0.29,-0.76 -0.31,-1.85 0.81,-1.56 1.12,-0.42 3.77,-0.73 3.25,-2.41 -1.57,-3.03 -4.11,-5.66 -7.19,-7.13 -1.41,-0.06 -0.96,1.83 -1.06,2.44 -2.21,-0.78 -4.11,-2.36 -5.72,-3.97 -2,-1.09 -3.32,-3.29 -5.31,-4.5 -2.19,-2 -5.79,-2.98 -6.56,-6.06 -0.14,-0.14 -0.33,-0.24 -0.53,-0.25 z",
						"eng" : "m 564.31,573.38 -0.09,0.03 c -2.28,0.35 -2.22,2.86 -2.28,4.59 -0.82,0.62 -1.78,1.35 -2.16,2.47 -0.57,0.81 -2.38,0.18 -2.19,1.69 -0.17,0.75 -1.72,0.73 -1.31,1.88 -1.18,1.83 -3.29,3.24 -3.59,5.47 -1.37,0.33 -0.17,2.71 -1.75,2.5 -1.5,0.2 -3.15,-0.44 -4.56,0.13 -0.09,0.73 0.54,1.41 0.59,2.28 1.19,1.69 1.02,3.97 2.75,5.31 2.04,1.38 2.6,3.8 2.56,6.13 0.52,1.31 1.35,2.44 1.56,3.84 0.62,0.96 3.05,0.75 2.16,2.34 -1.25,1.58 -2.18,4.08 -4.63,4.03 -2.48,-0.03 -4.11,2.17 -6.25,3 -0.93,1.74 0.57,4.5 -1.91,5.34 -1.13,0.95 -2.76,1.92 -3.94,0.44 -1.53,-0.82 -3.4,0.22 -4.81,0.75 -0.89,1.48 -2.09,2.68 -3.56,3.63 -1.9,1.92 -4.45,3.58 -5.56,6.06 -0.04,0.88 1.7,1.15 0.88,2.03 -1.45,0.39 -1.24,2.37 -2.66,2.81 -2.38,1.79 -2.53,5.5 -5.59,6.47 -1.8,1.25 -3.6,2.61 -5.72,3.13 -2.39,3.8 -5.88,6.82 -9.22,9.84 -1.36,0.31 -4.76,-1.51 -4.78,0.53 0.74,2.31 -1.47,4.31 -0.81,6.69 0.48,0.74 0.02,1.67 -0.88,1.31 -1.36,0.3 -1.62,2.91 0.19,2.03 0.73,0.19 1.49,1.81 0.06,1.44 -1.54,0.87 -3.16,2.33 -5.09,2.06 -1.68,-0.51 -3.31,-1.49 -4.38,-2.75 -1.91,-0.39 -3.39,1.29 -5.25,1.47 -1.34,0.25 -3.17,2.76 -1.03,3.19 1.48,0.09 2.83,-1.54 4.19,-0.19 0.47,0.42 0.26,1.53 -0.47,0.81 -1.41,-0.19 -1.52,1.76 -2.78,2.09 -0.59,0.74 0.17,2.22 -0.88,2.66 -0.94,-1.24 -1.68,-2.95 -3.5,-3 -1.65,-0.96 -2.86,1.48 -3.66,2.59 -0.61,1.74 -1.07,3.49 -2,5.16 -1.04,2.84 0.66,6.55 -2.06,8.72 -1.66,1.55 -3.41,3.08 -4.09,5.34 -1.14,2.36 -3.63,4.2 -3.47,7.13 0.36,2.49 -0.77,4.77 -0.72,7.22 -0.63,1.72 -1.26,3.55 -2.13,5.19 -0.89,0.59 -1.8,1.62 -0.91,2.69 0.63,1.09 2.13,1.2 2.59,2.5 2.48,4.22 6.19,7.77 8.47,12.13 0.7,0.48 1.65,0.13 2.34,0.84 0.59,0.51 1.94,-1.03 1.75,0.25 -0.46,0.92 -0.01,1.99 1,2.03 0.43,1.61 -2.22,1.05 -2.09,2.59 -0.41,3.37 0.54,6.85 3,9.22 1.52,1.67 1.95,4.7 4.25,5.47 0.93,0.15 1.4,-1.32 2.25,-0.28 1.22,0.72 2.26,-0.87 1.13,-1.66 -0.06,-1.89 1.72,-3.48 1.41,-5.5 -0.07,-0.56 0.41,-2.33 0.91,-0.81 1.31,2.16 2.71,4.75 1.31,7.25 -0.58,1.52 -0.54,3.48 -2.03,4.34 -0.58,2.1 -0.75,4.58 -0.03,6.66 0.97,1.09 1.81,-1.56 2.75,-0.09 0.96,0.4 0.57,2.45 1.91,1.75 3.16,-2.17 4.86,-5.89 6.53,-9.16 -0.56,-2.02 1.97,-3.87 0.63,-5.72 -0.36,-1.2 0.67,-3.34 2.06,-2.72 0.13,1.62 0.45,3.33 0.78,4.94 -0.63,0.86 -0.36,1.94 0.69,2.41 1.64,0.48 -0.24,2.77 1.56,2.94 3.28,0.51 3.47,-3.73 5.66,-5.09 1.19,-0.93 3.23,-0.35 3.75,-2.16 0.61,-0.72 2.07,-0.88 1.63,-2.19 -0.38,-0.66 -0.13,-1.66 0.72,-1.19 0.77,0.66 0.71,2.08 1.28,2.75 l -0.31,0 -0.34,0.13 c -1.53,1.02 -1.81,3.02 -3.78,3.47 -1.22,0.97 0.66,2.65 1.19,3.75 0.63,0.62 0.34,2.15 1.66,2 1.05,0.48 1.8,2.01 0.59,2.78 -0.58,1.86 -1.07,4.08 -3.16,4.88 -2.3,0.67 -3.55,3.1 -4.31,5.16 0.66,0.81 0.39,1.94 0.81,2.88 1.1,0.9 2.95,-0.46 3.66,-1.22 0.09,-1.07 -0.67,-2.78 -0.19,-3.59 1.8,0.86 1.34,3.62 1.16,5.25 -0.48,1.15 -2.57,0.32 -2.66,2 -0.56,1.17 0.99,1.32 1.38,1.94 -0.34,0.89 -1.83,1.1 -1.91,2.19 -0.95,0.66 -2.39,0.99 -3.28,0.22 -1.58,0.38 -3.46,1 -4.5,2.22 -0.07,2.33 1.33,4.25 2.31,6.16 -0.27,1.76 2.2,1.17 3.16,0.75 0.61,0.92 -1.28,1.93 -2.13,1.94 -1.14,-0.5 -3.32,-1.19 -2.66,-2.84 -0.47,-1.19 -1.99,-1.84 -1.81,-3.41 0.17,-0.97 -1.03,-3.2 -1.84,-1.59 -1.19,5.67 -0.81,11.57 -0.91,17.34 1.28,1.82 3.34,3.54 5.78,2.94 2.28,0.15 4.55,0.51 6.78,-0.34 0.53,-0.03 2.33,-0.76 2.28,0.03 -0.71,0.68 0.05,2.18 -0.38,2.59 -1.25,-0.9 -3.2,-1.47 -4.41,-0.13 -0.33,1.23 -2.72,-0.58 -2.47,1.25 -0.81,2.1 -3.06,2.68 -4.06,4.72 -1,1.77 -2.87,2.83 -3.19,4.94 -1.1,3.01 -4.25,5.94 -3.13,9.34 0.84,1.32 2.76,1.72 2.38,3.66 0.04,2.2 1.74,3.74 2.63,5.53 -0.37,1.09 0.46,1.86 0.81,2.78 0.31,2.87 0.96,6.46 3.94,7.69 2.4,1.21 3.84,4.47 6.72,4.5 1.06,-0.46 2.17,-0.61 3.06,0.28 1.66,0.34 0.83,-2.31 2.34,-2.63 0.5,-0.41 2.48,0.03 1.81,0.75 -1.52,0.25 -1.96,1.95 -0.81,2.97 0.39,0.95 -1.31,1.57 -1.78,2.25 -0.95,1.01 -2.07,0.15 -3.03,-0.19 -1.01,-0.11 -1.67,0.88 -2.28,1.25 -3.69,-0.41 -6.81,-2.96 -8.22,-6.38 -1.49,-1.82 -2.17,-3.98 -2.63,-6.25 -0.64,-1.14 -0.88,-3.49 -2.41,-3.63 -2.1,1.01 -3.89,2.55 -6.13,3.34 -0.84,1.04 -3.39,0.68 -3,2.5 1.4,3.12 5.01,4.97 5.59,8.47 0.6,1.5 2.59,2.44 3.09,3.72 -1.2,-0.44 -2.88,1.44 -1.06,1.75 2.92,0.61 5.47,2.28 7.53,4.44 1.17,1.32 2.63,2.74 3.06,4.47 -0.45,1.89 -2.84,2.21 -4,3.44 0.97,1.7 2.93,4.08 5.16,3.63 0.55,-0.64 2.16,-0.48 1.5,0.66 -0.48,1.23 -0.98,2.7 0.22,3.66 0.01,1.24 1.28,1.81 1.13,3.13 0.09,1.54 0.07,3.29 1.31,4.38 0.04,1.24 0.9,2.51 2.34,2.25 1.89,-0.67 3.48,1.05 5.31,1.09 1.81,0.44 1.03,2.94 0.59,4.19 -0.77,1.11 -0.26,3.44 -2.19,3.22 -1.85,0.23 -2.29,2.31 -3.53,3.22 -1.16,-0.79 -1.02,-2.82 -2.19,-3.78 -1.42,-2.1 -4.21,-2.49 -6.34,-1.34 -1.8,0.15 -3.12,-3.23 -4.94,-1.63 -1.22,1.26 -1.86,3.36 -4,3.09 -1.87,-0.15 -3.47,0.36 -3.13,2.56 0.26,1.53 -2.92,1.94 -1.59,3.56 1.36,0.93 -0.28,1.76 -0.88,2.5 -0.31,1.31 -0.71,2.66 -0.88,4.03 0.78,0.81 0.37,2.7 2.03,2.66 0.96,0.27 1.89,-0.92 2.66,-0.72 0.79,0.92 0.3,2.8 2,2.81 2.59,0.17 3.34,3.33 5.78,4 1.04,0.36 1.5,2.86 -0.03,2.66 -1.16,-0.68 -3.39,-0.75 -3.28,1.06 -1.55,1.62 -1.31,3.96 -1.78,6 -0.93,0.97 -1.54,2.12 -1.72,3.47 -0.57,2.05 -1.95,3.84 -3.84,4.78 -0.09,1.26 1.15,2.65 1.88,3.63 2.32,-0.45 3.79,-3.03 6.13,-3.22 1.47,0.8 0.94,3.17 0.97,4.63 -0.26,0.93 0.3,2.99 -1.28,2.47 -1.51,0.05 -0.54,2.68 -2.28,2.09 -3.32,-0.11 -6.37,1.4 -9.19,2.91 -2.26,0.74 -3.57,4.63 -1.09,6 1.73,0.8 3.07,2.06 4.47,3.28 2.32,1.22 3.79,4.5 6.69,4.66 1.57,-0.35 4.2,-1.59 5.28,0.19 0.61,1.97 -1.73,2.66 -2.66,3.88 -0.23,1.34 -0.92,3.45 0.41,4.34 0.76,0.15 2.84,-0.19 2.63,1 -0.74,1.29 -2.14,1.15 -3.41,1.03 -1.28,0.11 -2.52,0.91 -2.72,2.19 -1.01,0.58 -1.77,1.4 -1.94,2.59 -0.33,0.79 -1.98,2.39 -0.5,2.75 l -0.31,0.19 -0.13,0.09 c -0.51,0.93 -2.09,3.22 0.03,3.06 1.21,-0.38 0.89,1.86 0.03,2.06 -0.99,0.32 -3.07,1.56 -1.44,2.44 0.67,0.74 1.22,1.89 0,2.41 -1.53,1.84 0.16,4.08 1.31,5.59 1.03,1.73 -0.45,3.69 0.66,5.47 0.9,3.18 4.27,4.94 4.91,8.19 0.77,1.05 3.15,-0.14 2.72,1.88 0.98,1.04 2.41,-0.83 3.5,-1.25 0.93,-0.9 2.19,-1.76 3.44,-0.75 1.77,0.96 2.54,3.02 4.28,4.09 2.25,1.26 1.7,4.74 4.09,5.69 1.84,0.04 3.74,0.27 5.34,1.16 0.47,2.38 -1.67,4.19 -1.25,6.59 -0.26,1.41 1.51,2.09 0.81,3.53 -0.27,1.2 -1.64,2.52 -0.5,3.69 0.29,1.56 0.69,3.12 0.94,4.66 -0.33,1.17 -1.41,3.37 0.31,3.94 1.49,-0.87 1.12,-3.35 2.78,-4.25 2.58,-2.21 6.34,-3.31 7.78,-6.59 1.02,-0.48 0.92,-1.86 2.19,-2.13 0.83,-0.75 3.86,-2.32 1.66,-3.09 -2.64,-0.8 -1.19,-4.81 1.03,-5 1.16,0.39 2.5,3.21 3.59,1.41 0.09,-0.51 -0.03,-2.13 0.72,-1.13 1.02,0.95 1.45,3.45 -0.59,3.34 -1.02,-0.35 -2.16,0.64 -1.25,1.5 0.43,1.04 0.82,2.57 -0.59,3.06 -1.21,1.05 -2.69,1.57 -4.16,2.03 -1.99,1.22 -1.45,4.08 -3.5,5.31 -2.14,1.7 -4.19,3.63 -4.91,6.38 -1.05,2.08 -3.17,3.41 -4.09,5.53 -1.8,1.46 -1.22,4.04 -2.63,5.78 -0.95,1.45 -1.93,3.3 -0.59,4.84 -0.96,0.37 -2.18,-1.16 -3.03,-0.03 -4.05,-0.19 -6.63,3.56 -8.72,6.5 -0.94,2.22 -2.52,4.98 -5.28,4.88 -1.43,0.65 -0.08,3.13 -1.81,3.56 -0.97,1.22 0.08,3.07 -0.94,4.38 -1.55,1.18 -1.49,3.51 -1.66,5.34 0.22,2.14 2.08,4.56 0.38,6.56 -0.56,0.4 -1.54,-0.03 -2.06,0.78 -1.2,1.43 -3.09,1.57 -4.66,0.69 -2.29,-0.69 -4.39,0.85 -6.66,0.94 -3.96,2.64 -9.1,2.08 -13.63,1.59 -1.38,-0.86 -2.29,-2.43 -3.94,-2.81 -1.92,-1.54 -4.61,-2.94 -7.16,-2.5 -1.13,1.2 -3.01,1.87 -4.56,1 -3.35,-0.64 -6.71,-1.82 -10.09,-1.91 -1.05,1.04 -2.43,0.56 -3.75,0.59 -1.28,0.55 -2.59,1.2 -4.06,0.72 -1.98,-0.26 -3.6,1.22 -5.59,1.06 -1.38,0.01 -2.58,0.78 -3.78,1.19 -1.3,-0.89 -2.85,-1.22 -4.25,-0.38 -2.13,0.45 -4.7,0.61 -6.38,2.06 -0.85,1.61 0.24,4.07 -1.25,5.28 -1.62,0.22 -0.69,2.4 0.16,3.03 0.58,1.42 -0.55,4.3 1.5,4.69 1.28,-0.15 1.73,-1.77 3.19,-1.28 1.07,-0.01 1.36,-1.39 2.59,-0.91 1.13,0.05 2.62,1.07 2.81,2 -1.31,0.27 -2.53,-0.88 -3.84,-0.03 -1.67,0.34 -3.51,1.23 -3.41,3.22 -9.5e-4,0.66 -1.05,2.53 -1.63,1.66 0.64,-1.25 -0.97,-2.64 -1.81,-1.25 -0.54,1.16 -2.07,1.2 -2.59,2.53 -1.2,2.07 -2.89,4.36 -5.63,4.06 -1.47,0.32 -2.89,-0.06 -3.72,-1.38 -2.16,-1.65 -5.09,-2.62 -7.75,-2 -0.57,3.96 -0.39,8.29 -2.22,11.88 -0.28,3.24 0.32,6.69 0.66,9.78 -1.04,2.06 0.39,5.35 -2.19,6.5 -2.25,1.71 -4.18,3.9 -5.06,6.56 -0.92,0.82 -1.18,2.19 -2.44,2.53 -0.53,0.56 -0.82,1.13 -1.63,1.31 -0.51,0.77 -1.22,1.19 -2.09,1.34 -0.86,1.1 -0.13,2.71 -1.09,3.78 -0.05,2.36 -1.57,5.08 -4.28,4.81 -1.47,-0.21 -2.49,0.93 -3.75,1.25 -2.1,-0.81 -2.6,2.14 -2.22,3.59 0.67,0.68 1.11,1.91 0.09,2.5 -0.78,0.59 -1.78,0.74 -1.5,-0.69 0.14,-1.12 -1.09,-3.04 -2.16,-1.69 -0.35,1.38 -1.73,1.05 -2.75,1.28 -1.37,0.96 0.21,3.11 -1.13,3.94 -0.36,1.91 0.39,3.97 -0.5,5.75 -0.02,1.78 -1.16,3.38 -2.44,4.41 0.14,1.06 -0.71,1.81 -1.78,1.47 -1.46,-0.64 -2.91,0.29 -2.91,1.91 -0.37,1.83 0.4,4.41 -1.75,5.31 -1.04,1.01 -1.61,2.81 -3.41,2.47 -1.09,0.41 -0.28,1.94 -1.03,2.72 -1.17,2.47 -4.15,3.4 -5.59,5.63 -1.27,1.24 -3.19,0.56 -4.5,1.53 -0.6,2.07 -2.68,3.39 -2.91,5.59 -0.17,0.92 -1.28,0.71 -1.03,-0.22 -0.37,-1.23 -1.92,-1.22 -2.22,-2.44 -1.72,-2.33 -4.58,-0.06 -6.25,1.09 -1.4,0.86 -2.69,2.11 -3.69,3.22 -1.44,0.64 -3.39,0.54 -4.09,2.31 -0.51,1.44 -1.12,2.87 -0.5,4.44 0.46,1.63 0.5,3.63 -1.22,4.59 -0.5,1.23 1.8,0.87 1.63,2.19 0.69,1.96 2.69,0.11 3.91,-0.22 2.37,-0.29 5.86,-1.36 5.78,-4.34 -0.11,-1.01 -1.6,-2.18 -0.09,-2.81 0.55,-0.93 0.94,-2.02 2.28,-1.94 3.11,-0.59 4.87,3.13 7.94,2.81 1.29,0.4 2.28,1.62 3.78,1.47 2.62,1.4 4.24,4.04 5.13,6.81 0.69,1.64 -0.24,3.56 1.06,5.06 0.51,1.15 2.01,1.37 2.25,2.63 1.59,0.58 1.35,-1.91 1.94,-2.72 0.43,-1.24 0.83,-2.73 2.5,-2.38 1.44,0.07 3.17,-0.38 3.28,-2.06 0.84,-1.14 2.66,-2.56 1.34,-4.06 -1.01,-0.55 -0.02,-2.24 -1.53,-2.16 -1.02,0.23 -0.94,-1.26 -2,-1.28 -0.37,-1.14 1.13,-1.37 1.88,-1.59 0.57,-0.77 -10e-4,-1.92 0.78,-2.69 0.6,-0.94 1.98,-2.92 0.16,-3.41 -0.93,-0.13 -1.03,-1.37 0,-1.41 0.78,-0.47 0.48,-1.48 1.31,-1.84 0.2,-0.95 1.2,-2.31 2,-2.31 0.51,0.87 1.13,1.77 1.72,2.56 -0.49,1.03 0.01,2.52 1.38,2 1.3,-0.67 0.84,-2.63 2,-3.56 0.96,-1.25 2.79,-0.15 3.75,-1.5 1.49,-0.9 2.55,-3.58 4.66,-2.47 1.49,0.74 3.11,-0.05 3.41,-1.69 0.18,-0.96 -0.68,-1.81 -0.34,-2.91 -0.13,-1.79 1.95,-3.01 1.19,-4.88 0.11,-2.43 3.54,-1.92 4.59,-3.56 1.3,0.19 1.42,1.63 1.84,2.53 2.72,0.57 5.61,-1.51 8.31,-0.09 1.75,0.25 3.1,-1.43 4.81,-1.34 1.42,-0.66 1.69,-2.91 3.56,-2.72 3.44,-0.03 7.24,-0.51 10.41,1.09 1.38,0.63 2.61,2.91 4.22,2.34 0.64,-1.07 -1.12,-1.38 -1.09,-2.44 -0.35,-0.56 -1.96,-1.08 -0.63,-1.59 1.11,-0.21 2.09,-1.45 1,-2.28 -0.02,-1.39 -0.35,-3.33 0.56,-4.44 1.62,-0.72 0.95,1.87 1.03,2.66 0.32,0.99 0.84,1.86 0.66,2.94 0.84,2.19 4.21,0.42 5.22,2.25 0.16,0.99 -1.37,1.35 -0.84,2.53 -0.07,1.23 0.81,2.18 2,2.19 1.55,0.56 2.57,3.48 4.41,1.81 1.73,-0.96 4.55,-0.24 5.31,-2.59 -0.12,-0.69 1.3,-1.37 0.97,-0.25 0.11,1.05 -1.22,3.02 0.53,3.22 1.58,1.37 3.68,2.71 4.25,4.75 -0.26,1.13 -0.26,2.43 1,2.84 1.1,1.24 3.05,2.59 4.34,0.78 1.64,-0.15 2.83,1.43 4.22,1.91 1.09,-0.41 1.75,-1.63 2.94,-1.91 1.4,-2.93 0.8,-6.56 2.72,-9.31 1.02,-1.87 3.33,-2.25 4.72,-3.72 1.57,0.1 2.7,-1.25 2.72,-2.81 0.06,-1.29 1.85,-3.04 0,-3.88 -0.96,-0.4 -2.64,-0.17 -2.63,-1.69 -0.28,-2.04 -0.19,-4.74 1.81,-5.78 1.04,1.16 2.83,-0.25 1.63,-1.41 -1.24,-2.11 -0.24,-4.88 0.41,-7.06 0.95,-1.8 2.11,-3.49 2.75,-5.44 1.8,-1.52 0.84,-4.11 0.5,-6.09 -0.23,-2.1 -1.96,-3.99 -1.88,-6.03 1.52,-0.13 2.63,1.86 3.28,3.09 0.11,1.76 1.59,3.02 1.84,4.78 0.53,1.35 2.65,1.29 3.28,0.09 1.48,-0.72 3.26,-1.61 3.19,-3.5 2.17,-0.24 2.78,-3.2 5.09,-3.38 2.84,-1.01 5.91,-0.57 8.78,-1.28 0.75,-0.82 1.49,-1.93 2.84,-1.53 3.71,1.16 6.93,-1.61 9.84,-3.44 5.09,0.87 10.31,2.39 14.69,5.31 5.08,2.93 9.18,7.14 13.72,10.81 1.75,0.78 2,-1.78 2.25,-2.94 0.67,-1.56 2.22,-2.87 4.03,-2.25 1.92,0.11 3.69,0.69 5.41,1.31 2.2,-0.18 4.46,1.43 6.53,0.44 1.82,-0.38 3.23,0.93 5,1.06 1.51,0.83 2.99,1.86 4.78,2 1.12,-0.01 0.4,2.2 1.91,1.41 1.49,-1.59 3.89,-0.93 5.72,-1.56 -0.08,-1.44 -0.3,-2.85 0.47,-4.13 0.32,-1.45 -0.57,-3.13 -2.03,-3.25 -0.58,-0.69 -1.56,-0.41 -2.09,-1.09 -1.07,0.26 -2.33,0.64 -3.06,-0.56 -0.25,-1.09 -2.45,-0.3 -1.69,-1.88 0.31,-1.75 1.41,-3.42 2.75,-4.5 1.2,0.17 2.76,-1.21 3.53,0.22 0.21,1.07 1.03,1.55 1.97,1.63 1.14,0.82 2.2,2.87 3.47,0.94 2.54,-1.72 5.68,-1.45 8.56,-1.44 0.8,-0.19 0.5,-1.61 1.53,-0.97 1.48,0.1 2.59,-1.2 4.16,-0.78 2.93,-0.24 5.58,1.4 8.41,1.53 2.24,-0.33 2.25,-2.86 2.69,-4.5 1.95,1.73 4.4,-0.18 6.53,-0.56 2.03,-0.27 1.37,-2.66 0.28,-3.63 -0.38,-0.68 -1.71,-1.51 -1.38,-2.34 1.01,-0.08 1.73,1.07 2.56,1.53 0.64,0.9 0.6,2.58 2.19,2.31 2.12,0.63 4.18,-1.84 3,-3.75 -0.8,-2.27 -3.06,-3.25 -4.22,-5.31 -1.26,-2.13 -3.35,-3.45 -5.28,-4.84 -0.59,-0.58 0.02,-1.86 0.66,-0.84 0.85,1.05 2.26,0.73 3.28,1.69 1.26,0.8 2.21,-0.6 2,-1.75 1.17,-0.39 1.53,1.05 0.91,1.88 -0.18,2.22 2.48,3.36 3.53,5.03 2.19,3.3 6.7,3.72 8.91,7 0.71,0.95 3.22,1.94 3.09,-0.06 0.01,-1.18 0.11,-2.87 -1.25,-3.03 0.19,-1.1 -1.25,-1.23 -1.5,-1.97 0.33,-1.84 2.51,-0.05 3.56,-0.38 0.57,-0.97 2.24,-0.6 2.28,0.63 0.65,0.65 1.12,1.46 0.31,2.16 0.05,1.25 -1,3.18 0.28,4 1.75,0.47 3.02,-1.25 2.53,-2.88 -0.07,-1.3 -0.78,-3.23 1.13,-3.53 0.93,-0.61 1.85,-1.15 2.84,-0.5 1.49,0.37 3.3,-0.98 4.5,0.19 0.87,0.15 1.85,0.2 2.5,0.78 0.7,0.1 0.94,-1.16 1.72,-0.44 1.37,0.81 -0.63,2.35 0.47,3.22 1.73,0.5 1.59,-2.22 2.72,-2.72 0.54,1.48 -0.09,4.24 -2.22,3.91 -1.65,-0.36 -3.47,0.44 -3.59,2.25 0.14,1.86 2.79,1.83 3.81,3.09 1.36,0.84 2.1,2.43 3.44,3.22 0.76,-0.66 2.38,-2.87 0.72,-3.5 -1.72,-0.15 0,-2.33 1.03,-1.97 2.84,0.38 5.3,-1.51 8.09,-1.78 3.61,-0.91 7.13,-1.96 10.91,-1.91 4.76,-0.11 9.84,-0.74 13.78,-3.56 5.81,1.01 11.73,1.87 17.06,4.5 2.23,1.07 4.74,1.26 7.03,1.97 1.57,0.94 2.9,2.54 4.88,2.38 2.19,0.54 4.03,2.64 6.31,2.56 2.12,-1.78 3.61,-4.22 5.5,-6.25 1.14,-2.27 3.29,-3.62 5.72,-4.25 3.82,-0.95 7.59,-2.33 11.47,-3.09 2.76,-0.74 5.42,-2.02 7.13,-4.38 1.25,-1.46 3.23,-2.55 4.44,-3.84 0.01,-1.02 -1.87,-1.79 -1.41,-2.69 4.17,2.43 9.03,3.47 13.75,4.28 2.43,0.74 1.78,-1.67 1.31,-3.09 -0.81,-4.18 0.62,-8.68 3.94,-11.44 2.49,-2.87 6.26,-3.34 9.75,-4 2.03,-0.5 3.01,-2.89 5.31,-2.78 3.05,-0.76 5.55,-2.78 8.19,-4.38 2.87,-2.64 2.02,-7.04 1.91,-10.53 -0.49,-2.55 -1.34,-5.03 -1.91,-7.56 -0.92,-0.77 -1.49,-2.27 -0.09,-2.94 1.38,-0.55 3.44,-0.23 4.06,-2.03 0.45,-1.41 1.63,-3.7 0.16,-4.81 -3.6,-0.59 -7.18,1.03 -10.81,1.06 -3.22,0.08 -6.43,0.18 -9.56,0.88 -2.73,0.29 -5.88,0.44 -8,2.31 -2.3,1.28 -4.89,0.14 -7.25,1.09 -1.19,-0.44 -2.24,-1.96 -3.75,-1.44 -1.9,-0.24 -4.03,-0.52 -5.69,-1.31 -0.01,-1.22 -0.46,-3.75 -2.19,-3 -0.8,1.14 -2.37,1.97 -3.72,1.75 -0.74,-1.34 -2.08,-0.66 -2.84,0.09 -1.94,-1.4 -5.08,-1.89 -5.81,-4.5 1.51,-0.71 4.46,0.12 4.81,-2.06 0.83,-1.18 2.58,-2.22 4,-1.81 0.53,1.31 2.74,1.86 3.06,0.13 0.52,-2.48 -2.54,-3.01 -4.34,-3.03 -3.77,-0.26 -7.53,-1.79 -11.34,-1.06 -1.58,0.89 -0.34,3.67 -2.47,3.97 -2.09,0.6 -4.76,1.17 -6.72,0.06 -0.16,-1.35 1.94,-1.15 2.81,-1.31 1.4,0.08 3.35,0.06 3.31,-1.81 0.18,-1.51 0.45,-4.06 2.59,-3.81 1.26,0.28 3.39,-0.58 2.5,-2.13 -0.54,-0.58 -0.57,-1.89 0.5,-1.31 1.02,0.33 1.18,-0.71 1.41,-1.34 2.06,-0.24 4.07,1.49 6.28,0.94 3.31,0.11 6.6,0.89 9.78,1.44 3,-1.61 5.18,-4.38 8.03,-6.28 1.13,-1.06 2.46,-2.14 3,-3.63 -0.95,-0.75 -2.36,0.55 -3.59,0.16 -1.61,-0.18 -3.85,0.25 -5.13,-0.78 -0.1,-1.25 2.03,-0.37 2.75,-0.66 1.68,-0.06 4.49,0.27 4.69,-2.09 0.66,-3.47 1.17,-7.15 0.63,-10.66 -0.89,-1.77 -2.82,0.05 -3.56,1 -1.14,1.52 -2.99,1.99 -4.78,1.69 -2.15,0.17 -3.05,3.53 -5.19,2.97 -0.41,-1.02 1.77,-1.7 0.31,-2.41 -1.32,-0.25 -3.02,-1.04 -3.5,-2.25 0.92,-0.84 2.05,-1.43 3.16,-0.66 1.08,-0.11 1.54,-1.6 2.84,-1.09 1.78,-0.06 4.5,0.75 5.66,-1 -0.38,-1.2 -1.25,-2.38 -0.47,-3.72 2.45,-0.17 5.11,-1.97 6.03,-4.34 0.91,-0.59 2.48,-1.36 1.47,-2.66 -0.63,-1.12 1.15,-0.48 1.19,0.25 0.46,1.44 0.74,2.95 2,4 0.95,0.99 2.26,2.06 1.81,3.59 1,1.16 3.04,0.24 4.38,0.25 4.25,-1.48 8.24,-4.4 10.63,-8.25 0.14,-1.36 -1.66,-0.29 -2.31,-1.16 -0.91,-0.55 -2.25,-0.89 -3.09,-1.19 0.3,-1.36 1.72,-2.17 1.94,-3.56 0.95,-0.65 2.42,-0.5 2.97,-1.78 1.09,-0.95 0.64,-3.52 -1.09,-2.88 -2.08,1.29 -4.68,-0.51 -6.91,0.34 -1.8,-0.12 -4.04,0.02 -5.53,-0.97 -0.46,-1.27 1.73,-1.23 2.47,-1.31 1.8,0.18 3.52,-0.64 4.81,-1.75 1.39,1.93 4.16,2.17 6.19,1.16 1.17,-0.88 0.42,-2.88 -1.03,-2.72 -2.57,-1.15 -5.73,-2.54 -6.38,-5.59 -0.23,-0.9 0.87,-1.6 1.19,-0.5 0.68,2.73 4.1,3.4 6.25,4.59 1.2,0.35 2.34,1.03 2.06,2.47 0.19,1.51 1.97,3.02 3.47,2.63 0.95,-0.88 2.28,-1.2 2.88,-2.53 0.59,-1.69 2.5,-2.44 3.13,-4.19 0.93,-1.2 1.15,-3.01 2.09,-4.09 1.61,-0.69 2.86,-2.07 4.63,-2.63 1.72,-0.75 3.91,-1.68 3.69,-3.97 0.49,-3.05 1.18,-6.12 2.09,-9 -0.34,-0.08 -0.68,-0.14 -1.03,-0.19 l 0.75,0 c 1.22,-1.39 0.28,-3.62 0.75,-5.31 0.29,-3.32 0.38,-7.2 3.19,-9.47 1.3,-2.24 1.82,-4.8 2.97,-7.16 1.14,-3.7 0.44,-7.94 2.78,-11.22 -0.03,-3.96 -2.27,-7.7 -1.41,-11.72 0.46,-4.41 -0.01,-8.86 -1.75,-12.97 -1.33,-5.15 -5.49,-8.88 -9.28,-12.31 -6.97,-5.6 -12.89,-13.54 -22.16,-15.31 -4.63,-0.53 -9.15,-1.6 -13.66,-2.78 -3.46,0.57 -7.03,0.05 -10.53,0 -0.67,0.11 -1.85,1.55 -2.28,0.41 0.06,-1.16 -0.98,-1.93 -1.97,-1.22 -1.5,-0.03 -3.17,-0.68 -4.41,0.53 -0.76,0.31 -1.33,0.02 -1.38,-0.72 -1.76,-1.19 -3.3,1.6 -5.03,0.44 -2.57,-0.64 -5.51,-0.62 -8.06,0.09 -3.23,1.89 -3.44,6 -4.81,9.09 -0.94,2.03 -0.04,5.23 -2.69,6.03 -1.95,1.04 -3.05,3.26 -3.22,5.28 -2.32,-0.41 -3.53,-4.08 -6.19,-2.41 -1.68,0.67 -3.65,-0.13 -4.81,-1.38 -0.76,-1.68 -1.54,-3.45 -2.56,-4.94 -0.38,-1.28 -2.02,-1.45 -2.84,-2.31 -2.61,-0.7 -5.35,-1.69 -7.97,-0.53 -1.4,-0.39 0.59,-1.53 0.53,-2.38 0.1,-0.89 0.14,-2.02 1.38,-1.81 2.21,-0.04 2.19,-3.03 3.34,-4.41 3.15,-4.97 7.94,-8.63 12,-12.88 1.2,-1.01 2.34,-2.78 4.09,-2.41 1.43,-1.37 0.78,-3.87 1.31,-5.66 0.73,-3.3 0.08,-6.57 -0.81,-9.75 -0.96,-4.63 -3.53,-8.75 -5.28,-13.09 -1.39,-2.12 -1.46,-4.8 -2.84,-6.84 -1.22,-0.35 -0.67,-2.06 -1.72,-2.69 -0.92,-1.79 -0.66,-4.44 -2.94,-5.25 -1.62,-1.3 -4.28,-0.98 -5.19,-3.13 -1.1,-1.36 -3.52,-0.78 -4,-2.75 -1.56,-1.88 -2.93,-4.46 -5.31,-5.31 -1.79,-0.02 -3.22,-1.94 -4.66,-2.91 -3.93,-3.21 -7.21,-7.18 -9.88,-11.56 -1.54,-1.77 -4.03,0.03 -5.84,0.34 -2.89,0.75 -6.47,-0.1 -8.72,2.31 -2.85,1.27 -5.9,-0.99 -7.41,-3.41 -1.91,-0.2 -3.64,1.39 -5.38,1.94 -1.81,-0.9 0.32,-3.06 1.41,-3.66 2.19,-1.54 5.24,-1.28 7.09,0.69 2.07,1.43 4.68,-0.29 6.97,-0.09 3.09,-0.26 6.23,-0.69 8.91,-2.28 1.99,-0.55 4.76,-0.65 6.31,0.84 1.17,3.25 4.21,5.41 6.44,7.94 1.71,1.85 4.08,4.22 6.81,2.84 2.41,-1.1 5.18,-2.2 7.72,-0.78 1.02,0.22 3.27,2.33 3.47,0.31 -2.14,-5.35 -6.4,-9.48 -9.41,-14.38 -4.58,-6.84 -9.92,-13.4 -12.06,-21.5 -1.6,-4.23 -2.77,-9.35 -0.69,-13.59 1.21,-1.74 2.68,-4.09 5.16,-3.56 1.01,0.12 3.3,-0.46 2.19,-1.84 -2.2,-1.23 -4.48,-2.36 -6.81,-3.31 -3.17,-0.61 -6.23,-3.05 -6.22,-6.53 0,-1.45 -1.05,-1.61 -2.28,-1.53 0.18,-1.69 -2.63,-1.7 -3.41,-2.97 -0.84,-1.5 -2.08,-2.77 -2.31,-4.53 -0.97,-1.62 -1.13,-3.45 -1.5,-5.22 -0.9,-0.68 -0.34,-2.22 -1.38,-2.66 -0.63,-2.57 -2.12,-5 -4.63,-6.06 -2.03,-1.38 -0.02,-4.55 -2.38,-5.75 -1.02,-1.61 -2.51,-2.82 -4.41,-3.25 -1.67,-0.57 -3.97,-1.03 -4.44,-2.97 -1.02,-1.3 -2.72,-1.04 -4.06,-1.44 -1.09,-0.61 -0.99,-2.22 -2.31,-2.72 -1.41,-0.79 -3.07,-0.95 -4.56,-1.63 -1.89,-0.22 -3.78,-0.49 -5.28,-1.75 -1.47,-0.39 -3.1,-0.05 -4.44,-1.03 -2.48,-1.17 -4.36,-3.52 -7.28,-3.69 -0.99,-0.56 -2.66,-0.57 -2.5,1 0.04,0.97 -0.08,1.98 -1.25,2.03 -1.37,0.91 -3,3.03 -4.72,1.53 -0.59,-0.22 -1.54,-1.4 -0.28,-1.13 0.95,0.2 2,1.17 2.75,-0.06 1.09,-0.96 2.46,-2.91 -0.06,-2.91 -1.17,-0.35 0.21,-2.02 0.91,-2.13 1.39,-0.4 0.45,-1.73 -0.13,-2.38 -0.7,-1.39 -1.93,-2.87 -1.25,-4.44 -1.1,-2.01 -3.64,-2.9 -4.66,-5.06 -1.95,-1.76 -2.71,-4.37 -2.94,-6.94 -0.96,-3.86 -3.11,-7.35 -3.06,-11.44 -0.21,-2.05 -0.22,-4.2 0.19,-6.16 -0.99,-1.87 -2.41,-3.77 -4.19,-4.94 -1.45,0.11 -1.09,2.94 -2.94,2.59 -0.88,-0.26 -1.25,-1.94 0.22,-1.53 0.94,-0.71 1.42,-1.95 2.19,-2.91 0.48,-2.13 -1.83,-3.61 -2.06,-5.69 -1.04,-2.02 -2.71,-3.75 -2.91,-6.13 -0.26,-1.28 -2.13,-1.06 -2.59,-1.94 0.6,-0.53 2.06,-1.58 0.66,-2.13 -0.71,-0.28 -2.39,-0.73 -2.53,-1.22 1.59,0.09 3.46,-0.2 3.84,-2.06 0.3,-2.27 -1.62,-4.26 -2.53,-6.22 -1.43,-2.3 -2.23,-5.42 -0.72,-7.84 0.7,-1.17 0.18,-2.53 -1.19,-2.84 -2.09,-0.3 -2.02,-1.92 -1.94,-3.66 0.3,-1.18 -1.06,-1.55 -1.13,-2.5 0.41,-0.76 1.72,-0.89 2,-1.94 0.8,-1.15 1.05,-2.73 0.16,-3.81 -0.59,-2.24 0.35,-5.17 -1.63,-6.81 -0.18,-1.52 -0.3,-3.15 -1.47,-4.28 -0.28,-1.8 0.41,-4.61 -1.53,-5.66 -1.7,-1.11 -3.15,-3.63 -5.41,-3.53 -0.7,0.61 -1.83,2.08 -2.53,0.59 -1.38,-1 0.9,-1.28 0.47,-2.41 -0.74,-1.67 -2.41,0.48 -3.53,-0.47 -2.09,-1.29 -3.3,-3.48 -4.09,-5.72 -2.24,-2.81 -5.7,-4.7 -7.06,-8.22 -0.85,-1.86 -1.61,-4.56 -3.75,-5.19 z m 49.31,574.69 c -0.08,0 -0.14,0.01 -0.22,0.03 -1.69,0.82 -2.19,3.05 -4.19,3.41 -1.09,0.87 1.29,1.38 0.13,2.22 -0.8,0.23 -1.88,0.1 -2.59,0.81 -0.69,0.45 -1.37,-0.04 -1.09,-0.84 -0.93,-1.1 -2.5,0.37 -3.44,0.94 -1.28,0.93 -1.89,3.25 -0.13,4 2.34,2.77 6.22,3.69 8.53,6.47 1.55,0.9 2.38,2.53 3.69,3.63 2.47,-0.11 5,-1.17 7.09,-2.47 1.76,-1.61 0.15,-4.63 2.31,-6.06 1.09,-1.4 3.99,-1.17 4.19,-3.13 -0.36,-0.72 -1.5,-1.04 -0.94,-2.06 0.34,-2.57 -3.01,-3.11 -4.88,-3.53 -1.21,0.05 -2.21,-0.27 -3.22,-0.78 -1.44,-0.11 -2.02,-2.94 -3.47,-2.09 0.08,1.9 1.21,4.62 -0.69,6.03 -0.18,-2.09 0.52,-4.76 -0.88,-6.5 -0.07,-0.04 -0.14,-0.06 -0.22,-0.06 z",
						"sct" : "m 645,0 c -0.86,0.48 -0.22,1.81 -1,2.47 -0.18,0.86 -1.62,1.37 -1.81,0.31 -0.07,-0.75 1.03,-1.81 -0.06,-2.25 -1.06,0.18 -2.18,0.97 -2.66,1.94 -0.23,1.1 -2.26,1.99 -0.69,3.06 0.77,1.32 -0.38,2.87 -0.31,4.25 -0.63,0.82 -1.37,1.7 -1,2.84 0.25,0.72 -0.03,1.01 -0.66,1.22 -0.87,0.7 0.5,1.28 0.16,2.09 -0.34,1.08 1.05,2.48 1.84,1.25 0.31,-0.92 1.69,-1.87 2.28,-0.63 0.85,0.76 2.41,0.91 3.34,0.31 0.44,-0.93 -0.75,-1.26 -1.28,-1.63 -0.43,-1.02 0.18,-2.36 0.97,-3.06 0.86,-0.6 2.41,-1.25 2.28,-2.47 -0.71,-0.97 -3,0.1 -3.09,-1.44 1.06,-0.65 2.82,0.67 3.47,-0.5 -0.05,-0.97 -1.28,-1.55 -1.22,-2.47 0.76,-1.1 2.52,0.69 3.28,-0.47 0.37,-1.01 -1.3,-1.4 -1.25,-2.22 0.73,-0.51 1.84,-1.59 0.31,-1.94 C 646.99,0.38 646,-0.1 645,0 z m -17.66,12.09 c -1.08,0.63 -1.51,2.29 -1.25,3.47 0.19,1.52 -0.75,3.11 -0.63,4.69 -0.11,0.8 -0.81,1.44 -0.41,2.34 0.35,1.28 1.82,2.13 1.91,3.47 -0.76,0.97 -1.21,-0.61 -1.72,-1.06 -0.55,-0.59 -1.53,-0.75 -1.56,-1.75 0.26,-1.37 -1.8,-1.27 -1.75,0 0.11,1.43 -1.16,2.62 -0.44,4.06 0.94,1.83 1.2,4 0.81,6 0.31,1.87 0.82,3.69 1.91,5.28 0.36,1.21 2.41,0.52 1.78,-0.72 -0.11,-0.78 0.61,-1.86 1.38,-1.06 1.05,0.66 2.32,2.24 3.59,1.09 1.24,-0.87 1.28,-2.56 0.44,-3.72 -0.17,-0.54 -0.98,-2.04 0.03,-2.13 0.88,0.4 1.67,-0.34 1.5,-1.25 0.3,-0.45 0.86,-0.95 0.47,-1.63 -0.3,-0.74 -1.03,-1.11 -1.44,-1.72 -1.06,-0.67 -2.48,-0.47 -3.53,-1.03 -0.4,-0.88 1.24,-1.21 1.88,-1.19 0.9,0.76 2.83,0.35 2.41,-1.09 -0.29,-0.85 -1.4,-0.92 -1.69,-1.84 -0.26,-0.88 -0.98,-1.81 -0.84,-2.69 0.9,-0.26 1.77,0.6 1.94,1.44 0.61,0.99 2.4,0.73 2.19,-0.59 -0.01,-2.03 -10e-4,-4.25 -0.91,-6.06 0.32,-1.62 -0.79,-2.24 -2.25,-1.91 -0.8,-0.15 -1.58,0.3 -2,0.81 -0.59,-0.39 -0.96,-1.32 -1.81,-1.22 z m -20.06,13.34 c -1.19,-0.09 -0.75,1.42 -1.72,1.72 -1.06,0.81 0.7,2.64 -0.78,3.19 -0.93,0.37 -1.62,1.12 -2.09,1.91 -0.69,0.25 -1.81,0.91 -0.97,1.69 1.08,1.11 2,3.13 3.84,2.41 0.69,0.23 2.18,-0.85 2.47,0.09 -0.41,0.88 -1.82,0.81 -2.66,1 -2.4,0.27 -4.17,-1.84 -5.88,-3.19 -0.8,-0.51 -0.04,-2.27 -1.38,-2.03 -1.36,0.53 -1.51,2.02 -1.5,3.25 -0.41,0.66 -0.16,1.42 0.13,2.03 -0.73,0.69 -0.11,1.73 0.84,1.5 0.83,0.77 2.04,0.99 3.16,0.63 0.81,0.3 1.71,0.36 2.31,-0.44 0.45,-0.37 1.06,-0.16 0.78,0.56 -0.1,1.13 1.4,0.68 1.66,1.41 -0.1,0.78 -1.96,1.3 -0.66,1.91 0.48,-0.21 2.07,0.25 0.94,0.75 -1.28,0.48 -2.31,2.86 -0.66,3.47 1.15,0.4 2.72,-0.69 3.53,0.53 1.04,0.5 1.21,-0.99 0.97,-1.69 0.2,-0.45 0.46,-0.97 0.56,-1.47 0.87,-0.25 0.3,-1.4 0.56,-1.78 1.05,-0.24 1.86,-2.3 0.34,-2.38 -1.02,-0.28 0.38,-1.14 0.31,-1.75 0.31,-0.9 0.11,-2.65 -1.22,-2.13 -0.25,-0.76 -1.11,-1.81 -0.16,-2.44 0.13,-0.88 0.84,-0.96 1.59,-0.88 1.81,-0.2 1.5,-2.9 0.56,-3.88 -0.46,-0.68 -0.56,-1.56 -0.81,-2.28 0.03,-1.65 -2.01,-0.69 -2.84,-1.53 -0.39,-0.19 -0.83,-0.21 -1.25,-0.19 z m 11.75,13.63 -0.09,0.03 c -1.25,0.79 -2.69,2.15 -2.66,3.75 0.07,0.64 1.27,0.85 0.44,1.5 -0.75,0.45 -1.82,-0.14 -2.63,0.44 -1.16,0.46 -3.12,1.34 -2.72,2.88 0.31,0.22 1.28,0.45 0.69,0.97 -0.93,0.15 -1.59,1 -1.13,1.97 -0.11,1.6 0.68,2.72 2.34,2 0.94,-0.09 1.85,0.33 2.22,1.19 0.19,0.44 1.49,0.52 1.19,1.06 -1.38,0.99 -3.1,-1.37 -4.41,0 -0.5,0.65 0.18,2.24 -1.03,2.16 -0.5,-0.74 -1.75,-0.45 -1.53,0.53 -0.2,1.69 0.62,3.72 -0.41,5.19 -0.66,0.33 -1.22,-0.2 -1.09,-0.91 -0.12,-1.11 0.03,-3.29 -1.72,-2.41 -0.67,0.03 -1.71,-0.77 -1.75,0.47 0.06,0.65 0.01,2.06 -1,1.5 -1.52,0.02 -0.1,2.46 -1.59,2.47 -1.19,0.33 -0.61,-1.37 -0.94,-1.97 -0.37,-0.88 -0.34,-2.77 -1.66,-2.66 -0.9,0.32 -1.16,1.36 -1.09,2.22 -1.44,-0.15 -3.26,0.3 -4.53,-0.34 -0.19,-1.45 -2.12,-0.7 -3.09,-0.72 -1.1,0.2 -3.19,0.26 -3.16,1.75 0.18,0.62 1.41,0.15 0.91,1.06 -0.68,1.41 -1.31,3.45 0.22,4.59 0.56,0.73 1.51,0.89 2.31,0.78 0.39,0.62 -0.04,1.73 1.06,1.78 0.82,0.13 1.01,-0.88 1.84,-0.75 0.56,-0.6 1.46,-0.3 2.19,-0.53 1.05,-0.14 1.62,1.91 2.53,0.75 0.45,-0.9 -1.05,-1.78 0.03,-2.47 0.43,-0.42 1.36,-0.12 0.97,0.56 0.31,0.6 1.22,0.59 1.28,1.41 0.36,0.62 1.95,-0.21 1.56,0.94 -0.57,0.37 -0.34,1.37 -0.69,1.69 -0.99,0.34 -1.85,-0.21 -2.78,-0.13 -1.24,0.05 -1.97,2.35 -0.31,2.19 0.54,-0.11 1.18,-0.35 1.25,0.44 0.59,1.21 1.75,1.92 2.94,2.31 1.1,-0.34 0.26,-1.89 1.13,-2.56 0.25,-0.49 1.14,-1.32 0.91,-0.19 -0.46,1.15 1.19,1.95 1.53,0.66 0.1,-1.14 0.13,-2.26 0.56,-3.38 0.17,-0.65 0.1,-1.56 1.03,-1.44 0.9,-0.59 -0.06,-1.44 -0.72,-1.66 -0.7,-0.68 -1.36,-1.56 -2.19,-2 -0.07,-0.9 1.39,-0.47 1.94,-0.41 0.67,0.75 1.81,0.03 2.47,0.78 1.15,-0.1 0.9,1.36 0.91,2.09 0.11,0.82 0.46,3.23 1.53,1.97 0.92,-1.03 0.47,-2.52 1.34,-3.59 0.33,-0.44 0.63,-1.26 1.19,-1.38 0.84,1.14 -0.95,2.32 -0.63,3.59 0.1,1.12 0.02,2.5 0.91,3.25 0.65,1.39 -0.12,2.76 -0.59,4.06 0.07,0.84 0.56,1.8 1.25,2.31 0.62,-0.02 1.11,0.36 0.91,1.06 -0.18,2.09 -0.53,4.09 -1.41,6 -1.06,2.75 -1.22,5.86 -2.59,8.44 -0.72,0.33 -1.45,1.11 -0.78,1.91 0.79,1.25 0.42,2.94 0.28,4.34 -0.27,0.89 -1.19,0.74 -1.88,0.72 -1.18,0.66 0.76,2.48 -0.81,2.94 -1.23,0.32 -1.22,1.75 -0.31,2.44 0.96,0.73 1.93,-0.27 2.75,-0.66 1.7,0.26 1.44,3.03 3.34,3 1.26,-0.42 -0.05,-1.85 0.34,-2.78 -0.12,-0.9 -1.58,-1.77 -0.94,-2.72 1.84,-0.28 1.85,-2.81 1.72,-4.25 0.04,-1.18 -0.96,-2.3 -0.66,-3.44 0.85,0.02 1.15,-1.59 1.97,-0.63 0.78,0.72 2.02,-0.07 1.5,-1.06 -0.3,-0.92 -1.05,-2.37 -0.28,-3.19 0.7,-0.44 0.71,-1.45 1.5,-1.88 0.44,-1.09 -1.53,-2.12 -0.56,-3.22 0.58,-1.05 -1.34,-1.99 -0.47,-2.88 0.94,-0.22 1.7,-1.37 0.94,-2.16 -0.02,-1.17 1.72,-0.94 2.19,-1.88 1.01,-0.79 1.73,-2.25 0.69,-3.31 -0.18,-0.78 0.9,-1.99 -0.28,-2.41 -1.49,0.16 -2.38,2.2 -3.78,2.28 0.32,-1.23 2.36,-1.96 2.03,-3.38 -0.6,-0.78 -1.63,0.59 -2.16,0.19 -0.05,-1.24 1.94,-2.05 1.28,-3.19 -0.36,-0.1 -2.21,-0.04 -1.44,-0.91 0.41,-0.74 2.01,-0.52 1.53,-1.69 -0.28,-0.85 -0.72,-2.33 0.63,-2.47 0.87,0.11 1.43,1.42 2.47,0.88 0.99,-0.67 -0.66,-1.94 0.44,-2.53 1.06,-1.16 2.44,-2 3.88,-2.53 0.68,-1.27 -1.4,-1.26 -2.16,-1.22 -1,0.39 -0.68,-1.23 -1.66,-0.88 -0.22,0.49 -0.84,0.95 -1.22,0.31 -0.72,-0.87 0.26,-2.27 -0.94,-2.91 -0.52,-0.6 0.9,-0.7 1.19,-0.63 1.88,-0.03 4.44,0.62 5.78,-1.09 0.09,-0.8 0.13,-1.95 -0.56,-2.5 C 626.51,50.4 626.43,53.23 625,52.75 c -0.01,-0.66 -0.31,-2.01 -1.28,-1.41 -0.5,0.86 -1.5,-0.07 -1.13,-0.84 0.53,-1.49 -0.45,-2.62 -1.81,-1.47 -0.77,0.41 -1.66,0.74 -2.13,-0.19 -0.85,-0.47 -1.4,1.1 -2.09,0.84 0,-1.73 2.25,-2.09 3.25,-3.09 0.86,-0.28 1.39,-1.65 0.19,-1.81 -0.85,-0.4 0.24,-1.38 -0.06,-2.06 0.11,-1.2 0.75,-3.26 -0.91,-3.66 z m -118.63,132.47 c -0.1,-0.01 -0.2,-0 -0.34,0.03 l -0.16,0.03 c -1.14,-0.27 -2.04,0.88 -1.19,1.78 1.05,1.25 -0.04,3.71 1.91,4.31 1.25,0.92 2.3,-0.68 1.91,-1.81 0.81,-0.86 2.58,0.55 3.06,-0.69 -0.23,-0.71 -1.18,-0.65 -1.5,-1.28 -0.99,-0.15 -1.83,-0.82 -2.78,-0.97 -0.52,-0.37 -0.22,-1.36 -0.91,-1.41 z m -5.09,15.16 c -1.31,0.33 -2.14,1.85 -2.31,3.09 1.08,1.62 2.47,3.3 4.34,4 1.62,0.29 3.7,0.34 4.94,-0.91 0.37,-1.22 -1.33,-2.56 -0.06,-3.69 0.64,-0.68 -0.24,-1.78 -0.94,-0.97 -1.41,1.11 -3.93,0.66 -4.69,-1.06 -0.32,-0.34 -0.81,-0.53 -1.28,-0.47 z m -9.03,4.78 c -2.21,0.22 -4.05,1.54 -6.19,1.88 -1.1,0.53 -1.2,2.01 -2.34,2.56 -0.99,1.39 -0.38,3.31 -0.47,4.91 -0.21,0.92 1.39,1.49 0.53,2.31 -0.8,1.03 -0.85,2.4 -1.5,3.53 0.04,1.24 0.19,2.59 0.34,3.88 0.33,1.45 1.38,3.07 2.91,3.38 1.09,0.04 0.67,-2 1.88,-1.34 1.15,0.17 1.3,-2.11 2.56,-1.06 0.88,0.5 1.69,1.16 1.22,2.28 -0.38,1.81 0.58,4.25 2.75,4.06 1.43,-0.13 3.19,0.25 4.16,-1.06 0.89,-0.49 2,-0.57 2.69,-1.38 0.87,-0.52 1.55,0.5 2.47,0.13 1.66,-0.17 3.08,-1.26 4.03,-2.5 0.68,-0.28 1.69,0.04 1.34,0.94 -0.46,2.47 1.87,4.25 2.75,6.31 0.7,0.72 1.76,0.21 2.44,-0.16 1.53,-0.09 2.67,2.2 4.19,1.28 1,-0.68 2.33,-2.61 0.97,-3.53 -0.66,-0.41 -2.13,0.39 -2.25,-0.59 1,-0.65 0.76,-2.38 -0.34,-2.66 6.1e-4,-0.66 -0.12,-1.59 0.81,-1.56 1.03,-0.19 1.04,-1.65 -0.06,-1.66 -1.2,-0.52 -1.74,0.85 -2.41,1.53 -0.02,1.2 -1.71,0.47 -2.38,0.38 -1,-0.18 -0.63,-1.76 -0.75,-2.59 0.72,-0.69 0.5,-2.8 -0.84,-2.22 -0.68,0.67 -0.72,2.22 -2.03,2.09 -0.69,-0.06 -0.24,-1.28 -1.03,-1.47 -0.65,-0.2 -1.21,-0.32 -1.63,-0.91 -1.19,-0.63 -2.64,0.26 -3.09,1.38 -1.55,-0.08 -3.47,-0.48 -4.47,-1.72 -0.03,-0.85 1.16,-0.66 1.5,-1.34 0.74,-0.76 2.59,-0.94 2.06,-2.41 -0.46,-0.47 -0.36,-1.34 0.47,-1.25 0.96,-0.37 2.39,0.81 2.91,-0.56 0.43,-1.02 0.15,-2.43 -1.06,-2.69 -0.78,-0.64 -1.81,-1.13 -2.44,-1.88 -0.02,-1.03 -0.35,-2.56 -1.72,-2.28 -2.23,-0.88 -4.37,-2.27 -6.53,-3.34 -0.27,-0.53 -0.87,-0.71 -1.44,-0.66 z m -9.31,25.5 c -1.02,0.22 -1.84,0.96 -2.91,1.03 -1.38,0.66 -1.45,2.27 -1.78,3.53 -0.97,0.63 -0.36,1.95 0.72,1.84 0.93,0.03 2.57,-0.2 2.53,1.19 -0.22,1.49 0.55,2.83 1.75,3.66 1.03,0.75 1.63,1.83 1.72,3.09 0.46,1.39 2.33,3.31 3.75,1.94 0.7,-0.79 0.91,-2.19 2.22,-2.19 0.77,-0.46 2.75,-0.66 2.28,-1.91 -0.55,-0.21 -0.82,-0.55 -0.75,-1.19 -0.4,-0.41 -0.71,-1.19 -0.06,-1.56 0.99,-0.94 -0.83,-1.27 -1.03,-2.09 -0.66,-0.71 0.41,-1.69 -0.59,-2.22 -1.71,-1.23 -3.64,-2.35 -5.75,-2.59 -0.33,-0.52 -0.18,-1.34 -0.72,-1.69 -0.1,-0.64 -0.79,-0.93 -1.38,-0.84 z m 29.38,10.63 c -1.33,0.22 -2.59,0.93 -3.63,1.69 -0.45,0.9 -0.68,1.89 -1.59,2.44 -0.54,0.69 0.25,1.23 0.81,1.31 0.37,1.29 0.21,2.72 -0.03,4 0.33,1.47 2.64,2.98 3.59,1.19 0.97,-1.22 -0.67,-1.97 -1.22,-2.84 0.11,-0.78 1.36,-1.34 0.81,-2.28 -0.77,-1.25 1.14,-1.8 1.28,-2.94 0.75,-0.52 1.7,-1.85 0.56,-2.47 -0.19,-0.09 -0.39,-0.13 -0.59,-0.09 z m -31.38,19.34 c -1.78,0.39 -2.24,2.89 -0.5,3.69 0.84,0.91 3.58,0.96 2.69,2.75 -0.43,0.67 -1.15,2.45 -2.13,2.06 -1.07,-1.49 -3.32,-0.31 -4.38,-1.66 -2.45,-1.19 -4.92,2.37 -7.13,0.47 -0.91,-0.48 0.15,-2.19 -1.31,-1.81 -2.08,0.85 -4.82,-0.2 -6.59,1.28 -0.34,0.87 -1.83,0.19 -2.44,1 -1.44,1.16 -2.92,2.31 -4.38,3.34 -0.58,1.26 -2.09,0.67 -3,0.25 -1.83,0.47 -3.77,0.34 -5.59,0.69 -0.69,0.34 -1.17,1.2 -1.84,0.25 -1.67,-1.2 -3.96,-0.77 -5.75,-0.78 -0.43,-0.81 -0.69,-3.49 -2.06,-2.41 -0.34,1.08 -0.64,2.1 -1.63,2.75 -0.2,1.5 -1.69,1.18 -2.66,0.63 -1.23,-0.78 -3.21,-0.86 -3.53,0.84 -0.77,1.15 -2.15,0.74 -3.22,0.97 -0.37,0.52 -0.38,1.15 -1.13,1.38 -0.72,0.6 1.25,2.13 -0.31,1.97 -0.92,-0.69 -1.83,-1.44 -2.88,-2 -1.06,-1.79 -3.72,-1.11 -5.41,-0.88 -1.47,1.04 -1.99,3.02 -3.69,3.84 -1.41,0.8 -0.87,2.48 -2.06,3.41 -1.04,0.99 -1.81,3.01 -3.06,3.44 -0.96,-1.41 1.04,-2.97 1.06,-4.47 0.32,-1.37 0.3,-2.94 1.81,-3.63 1.08,-0.87 -0.18,-2.05 0.06,-3.13 -0.27,-1.03 -1.78,-0.49 -1.75,-1.72 -2.13,-1.93 -5.6,-2.78 -8.31,-1.72 -1.56,1.48 0.52,4.34 -1.63,5.56 -1.33,0.26 -3,0.63 -3.31,2.25 -0.3,0.98 0.12,2.38 -1.19,2.72 -1.58,0.91 -2.83,2.4 -3.97,3.69 -0.94,0.62 -2.29,-0.44 -1.28,-1.41 1.52,-3.11 3.66,-5.77 5.44,-8.66 1.45,-1.33 -1.22,-2.27 -2.28,-2.38 -0.51,-1.19 -2.1,-0.86 -2.69,-2.03 -0.97,-0.7 -3.62,-0.28 -3.09,1.25 0.65,0.56 1.7,1.11 1.03,2.13 -0.54,1.1 -1.38,2.62 -2.44,2.97 -0.13,-0.85 -1.97,-0.32 -1,-1.22 0.98,-0.79 2.39,-2.37 0.69,-3.31 -0.87,-1.42 0.39,-3.98 -1.78,-4.53 -2.38,-2.27 -5.85,-0.99 -8.66,-1.97 -0.59,-1.01 -2.21,-1.08 -1.97,0.38 -0.26,1.72 0.39,3.81 -1.16,5.03 -0.52,2.62 -3.4,3.5 -5.06,5.22 -0.94,1.3 -1.9,3.99 0.41,4.44 1,0.58 1.49,1.74 2.69,1.97 1.28,1.2 3.61,1.05 4.25,3.03 0.61,0.53 0.11,2.59 -0.72,1.5 -0.98,-1.47 -3.1,-3.44 -4.88,-1.88 -1.14,0.49 -1.2,2.17 0.19,2.34 0.79,0.33 3.49,0.48 2.22,1.88 -0.29,1.15 1.57,2.28 0.91,3.28 -0.77,0.56 -1.75,0.54 -2.13,-0.38 -1.45,-0.2 -2.15,-1.99 -3.78,-1.94 -0.59,-0.52 -2.14,-1.59 -2.06,-0.03 0.39,1.06 0.08,1.79 -0.72,2.47 -1.14,1.41 0.86,2.72 2.22,2.38 0.88,0.02 1.77,0.05 2.66,0.06 -1.5,0.03 -3,0.04 -4.5,0.09 -1.52,0.65 0.05,2.53 1.09,2.66 0.77,1.39 -0.18,3.4 1,4.56 1.64,3.04 5.36,2.82 8.31,2.84 1.53,0.31 3.71,-0.3 4.94,0.72 -0.13,1.27 -2.52,-0.06 -2.72,1.41 -0.16,1.28 2.41,2.25 1.44,3.41 -1.23,-0.06 -2.39,-1.11 -3.34,-1.88 -0.94,-1.61 -2.71,-2.03 -4.44,-1.69 -1.41,0.28 -2.81,-2.44 -3.84,-0.75 -0.04,1.09 -1.3,0.89 -1.72,0.22 -1.39,-0.71 -1.93,0.88 -1.91,1.91 -1.51,-1.56 -3.97,-1.88 -5.88,-0.78 -1.39,0.41 -2.46,2.15 -3.88,2.19 -0.35,-1.16 -1.35,-1.84 -2.38,-2.34 -0.5,-1.47 -3.82,-1.06 -2.69,0.75 0.86,1.12 2.02,1.99 2.5,3.34 1.33,0.52 0.92,2.33 2.34,2.78 1.53,0.78 0.92,3.62 3.09,3.63 0.67,-0.06 1.86,-0.95 2.25,-0.13 -0.61,1.16 -2.07,2.08 -1.69,3.56 -1.07,0.24 -0.71,1.29 -0.38,1.97 -0.19,1.77 -0.57,4.44 -2.84,4.66 -1.01,-0.5 -2.51,-0.77 -2.78,0.69 -1.07,0.15 -1.27,-1.71 -2.06,-2.22 -0.84,-1.01 -2.58,-3.61 -3.84,-1.69 -1.07,1.65 0.36,3.31 1.72,4.13 0.13,1 0.16,2.59 1.66,2.41 1.56,-0.57 2.89,0.73 2.94,2.22 0.39,0.83 1.6,0.3 1.63,1.41 1.05,1.07 1.47,2.72 3.25,2.81 2.25,0.64 4.24,2.38 6.63,2.44 0.99,1.46 -1.04,2.92 -1.78,3.88 1.48,2.1 4.06,2.85 5.75,4.75 1.81,1.46 3.11,3.76 3.5,6.03 0.02,0.87 -1.09,1.56 -1.44,0.44 -1.42,-2.17 -2.18,-5.26 -5,-5.97 -2.46,-1.12 -4.19,-4.7 -7.25,-3.97 -1,0.9 -3.02,-0.2 -3.5,1.19 0.26,1.95 1.97,3.2 3.88,3.22 1.2,0.14 1.91,0.93 2.31,1.94 0.73,0.18 1.52,1.85 0.28,1.66 -2.46,-0.85 -5.31,-1.18 -7.34,-2.88 -1.03,-1.88 -3.31,-2.95 -5.19,-3.88 -1.88,-0.14 -0.85,2.52 -1.78,3.47 -0.7,0.76 -0.32,2.72 -1.84,2.28 -1.64,-0.39 -3.21,-1.2 -4.88,-1.56 -1.64,-1.48 -1.23,-4.41 -3.41,-5.53 -1.17,-1.59 -2.44,-0.58 -3.09,0.75 -0.73,1.72 -0.97,4.59 0.91,5.63 1.94,0.61 3.27,2.49 2.53,4.53 -0.6,0.9 -0.1,1.85 0.47,2.56 -0.68,0.77 -1.47,1.62 -1.16,2.66 -1.06,1.75 -3.25,0.02 -3.91,-1.19 -1.46,-1.16 -1.46,-2.98 -1.75,-4.63 -0.61,-1.41 -2.17,-2.63 -1.25,-4.34 -0.62,-1.27 -2.76,-0.32 -4,-0.34 -1.07,0.5 -2.63,0.42 -3.28,1.5 -1.05,2.98 0.65,6.03 0.09,9.09 -0.11,1.15 -0.04,2.47 1.28,2.72 1.61,1.52 3.86,1.38 5.84,1.69 1.37,0.95 2.44,3.76 0.97,4.97 -1.98,-0.28 -4.14,-3.07 -5.97,-0.94 -1.04,0.97 -1.24,2.44 -2.16,3.53 -0.79,1.41 0.3,2.87 1.66,3.31 1.68,1.15 3.26,2.65 3.5,4.75 0.47,1.68 3.34,0.91 3.22,2.81 -0.7,2.51 2.72,1.08 4.09,1.34 2.29,0.17 5.37,-0.63 7.09,1.22 0.67,1.47 -0.97,2.17 -2.19,2 -2.36,-0.04 -5.08,0.14 -6.66,2.09 -0.88,0.21 -1.76,-0.13 -1.97,-1 -1.16,-0.68 -2.32,-1.37 -3.19,-2.44 -0.89,-0.59 -2.35,-0.08 -2.72,-1.38 -1.43,-0.64 -2.35,-2.7 -4.06,-2.41 -1.06,0.67 -0.65,2.23 -1.66,3 -0.33,2.03 -0.9,3.96 -1.31,5.97 0.11,1.77 -0.04,3.99 0.94,5.38 0.91,0.21 3.62,-0.22 2.78,1.53 -0.74,0.76 -1.12,1.89 -0.22,2.75 0.46,0.93 0.64,2.1 0,2.84 0.41,1.13 0.69,2.33 1.28,3.34 2.58,1.29 5.05,-1.26 6.91,-2.78 1.8,-1.33 4.11,-2.26 5.13,-4.34 1.47,-0.16 0.16,1.65 1,2.16 1.14,0.57 -0.19,2.19 -1.16,2.31 -0.98,1.28 1.24,0.93 1.84,1.56 2.73,0.99 4.18,-2.46 5.84,-3.94 1.12,-0.58 1.81,-1.75 2.56,-2.63 0.83,0.01 2.77,0.68 1.47,1.69 -0.88,2.64 -3.37,4.36 -5.44,6.06 -1.8,0.22 -3.68,0.47 -5.22,1.59 -1.53,0.86 -3.99,0.27 -4.94,1.91 -1.59,0.68 -3.38,1.92 -2.81,3.94 1.15,1.4 3.29,0.36 4.75,0.13 1.29,0.81 2.99,0.28 4.16,1.19 1.67,-0.36 3.61,-0.45 4.84,-1.75 1.5,-0.31 0.69,-2.5 2.34,-2.59 0.85,-0.16 2.61,-1.08 3.19,-0.13 -0.5,1.49 -3.26,0.87 -3.66,2.56 -0.72,1.02 -2.72,2.02 -0.78,3.06 1.66,1.72 3.46,3.88 6.13,3.53 0.64,-0.05 1.65,0.46 0.69,0.97 -1.06,0.38 -1.81,2.91 -3.09,1.78 -2.26,-1.73 -4.16,-3.94 -6.03,-6 -2.03,0.15 -3.88,1.58 -5.94,1.91 -1.33,0.05 -2.26,1.63 -0.97,2.5 1.7,1.47 -0.54,3.41 -1.59,4.47 -1.13,0.79 -2.98,2.48 -1.41,3.78 1.56,1.66 4.09,0.04 5.88,1.28 1.91,0.4 2.81,2.12 3.44,3.81 2.58,0.78 5.32,-0.44 7.91,-0.84 0.81,-0.09 2.64,0.41 2.28,1.38 -2.83,0.27 -5.99,0.32 -8.47,1.81 -0.31,1.52 -1.89,0.24 -2.69,-0.16 -1.84,-1.08 -2.96,-3.23 -5.31,-3.41 -1.77,-0.27 -3.4,0.39 -5.16,0.47 -1.23,0.68 -1.08,2.55 -2.53,3.09 -1.07,1.01 -3.11,2.21 -2.81,3.88 0.6,0.95 2.28,-0.34 2.34,1.13 1.47,1.41 5.71,-0.86 5.78,2.13 -1.66,0.76 -0.03,3.1 1.09,3.66 0.99,0.18 1.78,1.1 2.91,0.5 2.12,-0.27 4.07,-1.96 6.19,-1.75 0.48,0.49 1.25,2.08 -0.13,1.75 -2.27,0.46 -4.39,1.26 -6.59,1.84 -1.79,1.39 -4.21,-0.17 -5.78,-1.16 -1.68,-0.72 -1.46,-3.93 -3.69,-3.22 -1.91,0.27 -4.99,-0 -5.25,2.63 -0.62,1.38 1.07,1.82 1.03,3.16 -0.23,0.67 -2.01,-0.15 -2.13,1.19 -0.6,1.09 -0.51,2.38 -1.06,3.44 0.04,1.05 2.35,0.97 1.22,2.19 -0.97,0.61 -0.61,2.21 0.63,1.63 2.31,-0.22 4.71,-1.43 7,-0.91 0.8,0.39 1.13,1.82 -0.13,1.53 -0.93,0.29 -3.21,1.34 -2.22,2.34 1.44,0.62 3.22,0.48 4,-1.06 0.33,-0.97 2.6,-1.88 2.56,-0.28 -0.69,1.07 -2.28,1.47 -2.53,2.94 -1.12,1.62 -3.48,-0.25 -4.84,1.22 -0.86,0.31 -1.86,0.33 -2.56,0.84 -1.07,-0.43 -3.46,-0.16 -2.38,1.47 1.83,1.92 4.73,2.03 6.81,3.38 0.46,1.47 -2.01,0.36 -2.97,0.56 -1.34,-0.4 -2,0.65 -2.41,1.66 -1.29,-0.04 -1.03,1.41 -0.44,1.97 0.18,1.64 -1.84,1.45 -2.75,0.88 0.04,-0.97 -1.03,-1.77 -1.59,-0.78 -1.3,0.49 -1.05,-1.61 -2.19,-1.88 -2.14,-1.74 -4.49,0.67 -6.78,0.56 -2.77,0.45 -5.94,-0.49 -8.41,1.06 -1.36,0.35 -1.02,2.34 -2.47,2.59 -1.54,0.74 -1.43,2.75 0,3.56 1.48,1.21 3.71,1.39 5.16,0.13 2.25,-0.25 4.47,0.24 6.5,1.06 1.98,0.42 4.05,0.08 5.94,-0.28 2.06,1.26 4.78,1.03 7.06,0.91 1.74,-1.55 3.2,-4.42 6,-3.72 3.04,-0.06 4.96,4.18 8.13,2.72 1.95,-0.47 4.53,-0.66 6.16,0.47 -2.27,1.06 -5.18,0.93 -7.72,1.19 -1.97,0.02 -4.26,-0.02 -5.53,-1.81 -1.33,-1.3 -3.15,0.28 -3.97,1.41 -1.63,1.17 -3.44,2.52 -5.44,2.66 -1.05,1.41 1.43,1.56 2.13,2.28 0.9,0.39 0.9,2.56 -0.28,1.31 -1.36,-1.17 -3.37,-1.51 -4.44,-2.91 -2.05,-0.14 -4.46,-0.16 -6.28,0.88 -1.17,1.74 1.33,2.73 1.91,4 1.07,2.46 3.06,4.69 5.44,5.91 2.41,0.08 4.67,2.31 7.09,1.53 0.86,-0.82 1.5,-3.4 3.06,-2.69 0.25,1.28 -2.12,2.91 -0.72,4.03 1.07,0.33 1.92,1.41 3.19,1.41 0.99,0.52 2.02,1.41 3.22,0.66 4.48,-2.18 8.17,-6.13 10.09,-10.69 -0.38,-0.39 -2.47,-0.79 -1.47,-1.56 1.82,0.14 3.94,0.3 5.03,-1.53 0.91,-1.16 2.11,-2.02 3.5,-2.44 1.43,-0.73 2.11,-2.15 2.72,-3.47 1.58,-0.85 2.51,-2.66 4.16,-3.31 1.43,0.37 2.93,-0.67 2.53,-2.22 0.59,-1.28 1.67,-2.47 1.44,-4 2.76,-1.55 5.14,-3.96 7.09,-6.44 0.16,-1.31 -1.66,-1.01 -2.41,-1.69 -3.72,-0.85 -8.12,0.44 -11.47,-1.69 -0.58,-0.85 1.55,-0.38 2,-0.53 3.16,0.3 6.62,-0.14 9.59,0.94 1.38,1.18 3.67,0.19 4.72,1.94 0.26,0.33 0.55,0.56 0.88,0.72 -0.23,6e-5 -0.46,-6e-5 -0.69,0 -3.26,3.43 -5.63,7.75 -8.59,11.5 -0.88,0.74 -1.11,2.5 0.41,2.5 1.91,-0.39 2.97,1.92 4.94,1.25 2.65,-1 5.38,-1.54 8.09,-2.38 0.86,-0.12 2.07,-0.51 2.75,0.09 -2.82,1.36 -6.46,1.43 -8.88,3.72 -1.33,0.7 -2.91,0.74 -4.09,-0.22 -1.88,-0.65 -3.87,0.05 -4.97,1.63 -1.06,0.69 -3.45,0.04 -3.25,2.03 0.74,2.24 -2.23,3.19 -3.22,4.75 -1.15,1.24 -3.06,3.42 -1.38,4.91 -0.79,0.54 -2.81,0.7 -1.91,2.16 0.31,1.65 2.26,2.1 3.28,0.78 1.11,-1.41 2.78,-1.81 4.47,-1.84 0.71,0.16 1.93,-1.61 2.22,-0.56 0.59,1.65 -1.29,1.96 -2.47,1.94 -1.7,0.53 -2.3,2.62 -4.13,3.06 -1.36,0.77 -2.96,0.89 -4.38,0.41 -1.46,0.73 0.21,2.68 0.44,3.75 0.05,1.03 1.81,2.89 0.13,3.34 -1.68,0.61 -4.84,0.21 -5.03,2.69 0.11,0.81 0.98,2.51 -0.56,2.34 -2.15,0.71 -2.85,3.52 -3.09,5.5 1.05,1.36 1.83,-1.59 2.94,-0.47 0.89,0.2 2.19,-1.44 2.75,-0.41 -0.57,1.91 -3.23,1.59 -4.44,2.81 -1.4,0.14 -3.37,-0.69 -3.97,1.19 -1.23,2.35 -0.64,5.23 -1.16,7.72 1.28,1 3.39,0 4.69,-0.59 0.81,-0.49 1.95,-0.49 1.81,0.72 0.77,0.39 0.52,0.94 -0.22,1.22 -1.36,0.99 -4.57,1.03 -3.41,3.38 0.5,1.85 -1.68,2.94 -2.06,4.63 -0.61,0.55 -0.86,2.47 0.44,1.81 1.38,-0.8 2.41,-3.26 4.22,-2.84 1.19,0.88 -0.92,2.27 -1.06,3.25 -0.77,1.75 -2.4,3.49 -2.38,5.34 1.53,0.83 2.37,2.36 1.94,4.09 0.06,1.15 -2,0.73 -2.16,-0.22 -1.21,-1.42 -2.59,0.61 -2.97,1.72 -0.9,1.09 -2.47,2.45 -1.97,4.09 1.45,1.17 2.21,-1.56 2.91,-2.44 0.97,-1.12 1.55,1.14 1.69,1.78 0.48,1.79 -0.96,3.16 -2.28,4.03 -1.19,2.28 -2.55,4.47 -4.03,6.59 -0.53,1.34 -1.89,2.99 -1.22,4.41 2.19,0.88 3.16,-2.12 4.81,-2.94 0.55,-0.38 2.61,-1.71 2.44,-0.16 -0.75,2.11 -3.07,3.34 -3.44,5.63 -1.93,2.81 -3.69,6.7 -2.13,10.03 0.8,1.23 2.15,-0.1 3.03,0.03 -0.13,0.97 0.55,3.16 1.78,2.03 1.19,-0.52 2.54,-1.15 3.44,-2.28 2.41,-2.05 3.72,-5.37 6.38,-7.09 0.3,1.06 -0.86,1.83 -0.75,2.94 -0.54,0.92 -1.37,1.69 -1.5,2.78 -1.93,2.24 -4.28,4.27 -6.72,5.81 -1.96,2.83 -3.33,6.06 -5.81,8.53 -0.88,1.67 -0.44,3.77 -1.16,5.56 -0.5,2.4 -0.81,4.96 -2.34,6.91 -0.06,5.47 0.26,11.15 -0.91,16.53 -0.31,1.12 -1.87,0.74 -2.38,1.84 -3.71,2.99 -2.49,8.21 -2.84,12.34 1.19,1.35 3.77,1.92 5.38,0.91 0.87,-1.41 3.11,-1.27 4.59,-1.53 2.34,0.27 5.09,-0.55 6.03,-2.84 1.51,-1.59 3.24,-3.95 1.81,-6.16 -0.55,-1.91 -2.27,-2.87 -4.09,-3 -0.72,-0.18 -1.72,-1.43 -0.44,-1.59 2.31,0.19 3.31,-2.23 3.5,-4.16 0.89,-1.85 2.18,-3.57 2.38,-5.72 0.97,-2.1 1.12,-4.43 1.19,-6.75 -0.27,-1.44 2.21,-0.37 1.63,-1.88 -0.76,-1.93 -1.11,-4.21 -0.88,-6.28 1.12,-1.58 0.91,-3.75 2.03,-5.34 0.02,-1.12 -0.05,-2.25 0.94,-3.09 1.05,-1.18 1.94,-2.73 2.97,-3.81 1.69,-0 2.86,-1.54 4.5,-1.69 1.19,-1.55 -0.01,-3.58 -0.63,-5.09 -0.61,-1.75 -2.26,-2.91 -3.13,-4.56 -0.33,-0.79 -1.53,-0.7 -1.91,-1.06 0.19,-2.35 -1.12,-4.44 -1.03,-6.81 0.13,-2.28 -1.92,-3.86 -1.53,-6.16 0.16,-2.22 -0.44,-4.83 0.66,-6.81 1.36,-0.2 0.49,1.94 1.34,2.56 1,1.55 2.82,0.21 3.47,-0.97 1.58,-0.88 1.92,-2.63 1.91,-4.31 -0.07,-1.03 0.8,-1.88 1.66,-0.97 1.62,0.25 1.02,-2.31 2.34,-2.88 1.51,-1.36 1.55,-3.73 3.41,-4.81 2.19,-2.48 6.65,-2.34 7.81,-5.78 -0.12,-2.49 1.98,-4.52 3.28,-6.47 0.41,-0.73 1,-0.92 1.5,-0.19 2.43,0.74 4.59,-1.59 6.56,-2.69 0.33,-0.6 2.14,-1 1.5,0.09 -1.98,2.87 -5.36,4.09 -8,6.19 -1.68,1.44 -2.66,3.54 -2.84,5.69 -1.86,1.78 -4.2,3.18 -6.75,3.59 -1.3,0.49 -1.41,1.98 -1.28,3.09 -2.44,2.85 -5.49,5.52 -6.38,9.31 -0.83,1.59 -2.54,2.78 -2.31,4.78 -0.5,0.93 -0.36,1.9 0.38,2.63 0.5,1.61 -0.93,2.94 -0.72,4.63 -0.46,1.75 0.2,3.47 1.69,4.5 0.76,0.99 0.94,2.46 2.44,2.72 1.1,0.07 1.91,0.41 2.47,1.38 1.02,0.96 2.26,-0.48 1.47,-1.53 -0.42,-1.64 -1.84,-3.21 -1.72,-4.88 1.19,-1.73 3.32,-3.14 2.78,-5.56 0.17,-1.24 -0.2,-3.36 1.03,-4.03 1.38,1.48 -0.77,4.63 1.5,5.78 1.68,1.05 2.99,3.5 5.13,3.5 1.25,-1.16 0.09,-3.26 -0.22,-4.66 -1.43,-2.25 -2.98,-4.79 -2.59,-7.53 0.56,-1.51 0.97,0.92 1.22,1.53 0.8,3.12 3.85,5.11 4.13,8.44 0.82,1.91 -0.17,5.17 2.13,6.16 2.46,0.99 3.29,-2.18 4.13,-3.78 0.97,-2.52 1.33,-5.16 3.09,-7.28 -0.24,-1.75 -3.35,-1.31 -3.75,-3 0.18,-0.72 0.86,-1.87 1.63,-0.88 0.66,0.63 3.02,2.12 2.78,0.16 -0.38,-2.2 -1.48,-4.56 -1.06,-6.78 1.11,-1.31 3.02,-3.56 1.09,-5.03 -2.14,-1.6 0.19,-4.7 -1.34,-6.47 -0.2,-0.62 0.36,-2.45 1.13,-2 1.62,2.24 0.94,5.24 1.28,7.75 1.36,-0.1 2.3,-2.01 2.97,-3.19 1.31,-3.11 2.8,-6.84 5.88,-8.56 0.87,0.67 -0.38,2.14 -1.03,2.66 -1.42,1.99 -2.33,4.31 -3.56,6.41 -0.42,1.66 -2.36,2.84 -2.19,4.72 0.89,0.45 1.71,1.03 1.91,2.16 1,2.51 1.98,5.48 4.5,6.78 0.99,0.73 2.46,0.56 3.22,1.78 1.69,1.89 3.03,4.2 5.63,5 2.91,1.49 6.45,1.55 9.28,2.94 -1.38,1.2 -3.82,0.23 -5.53,0.28 -4.95,-0.56 -10.18,-0.99 -14.41,-3.69 -1.94,-0.02 -4.36,0.34 -5.66,1.91 -0.46,1.64 0.24,3.6 -1,5 -0.49,3.89 -0.33,8.08 1.06,11.78 1.34,1.44 1.11,3.8 0.63,5.53 -0.94,1.34 -3.66,3.07 -2,4.88 2.09,2.04 3.77,4.36 5.53,6.69 1.25,1.34 3.34,0.58 4.63,1.88 1.4,0.45 0.77,-1.52 1.47,-1.91 0.87,0.14 0.37,1.68 1.25,2.09 1.24,1.27 0.99,3.23 2.09,4.63 0.8,2.23 -0.3,5.24 2.03,6.84 1.72,1.98 0.63,4.92 -0.44,7 -0.14,1.31 -0.56,2.74 -2.09,2.97 -2.85,0.79 -6.65,2.45 -6.34,6.03 0.2,1.74 -0.7,3.26 -2.22,4.06 -0.46,1.23 -1.77,1.76 -2.34,2.88 -0.03,2.64 0.03,5.3 -0.94,7.81 -0.27,1.68 -0.34,3.48 -1.81,4.66 -1.84,1.66 -2.89,3.97 -4.31,5.88 -1.8,0.96 -3.62,2.87 -3.44,5.03 -0.56,1.04 -0.61,2.21 -0.88,3.28 -2.04,2.71 -4.34,6.44 -2.34,9.81 1.23,3.19 3.41,6.2 3.72,9.63 -0.55,1.46 -2.49,2.44 -3.66,1.06 -3.01,-2.12 -1.81,-6.12 -2.56,-9.19 -1,-0.68 -0.61,-2.7 -2.09,-2.69 -1.2,0.95 -3.12,0.77 -3.66,2.44 -1.07,2.52 -0.83,5.43 -0.91,8.13 0.67,2.36 2.08,4.49 2.75,6.84 0.89,1.66 2.38,2.85 3.81,3.91 0.96,1.36 2.75,1.87 3.28,3.59 1.06,0.96 2.6,1.8 2.47,3.5 0.06,1.02 1.41,1.18 0.78,2.31 0.04,1.41 2.53,0.85 1.97,2.44 -0.31,1.03 0.52,1.86 0.69,2.66 -0.74,0.56 -2.23,1.34 -1.09,2.31 0.35,2.06 2.49,3.91 4.56,4 0.9,-0.76 -0.04,-2.27 0.59,-3.31 0.17,-1.61 -1.9,-2.35 -1.72,-4.03 -0.58,-3.2 -2.17,-6.06 -2.91,-9.22 -0.52,-1.01 -1.41,-2.19 -0.22,-3.13 0.95,-3.02 5.07,-3.07 6.38,-5.75 0.22,-0.81 1.86,0.09 2.56,-0.16 1.92,1 1.93,4.56 4.63,4.13 3.08,-0.54 4.41,2.86 6.72,4.13 1.33,1.24 3.46,1.32 4.19,3.19 0.55,1.35 1.03,2.83 2.47,3.5 2.05,1.97 4.1,4 6.94,4.72 1.31,0.72 3.69,2.61 4.72,0.56 0.56,-1.15 1.94,-2.35 0.53,-3.47 -0.73,-1.65 0.37,-3.36 0.06,-4.97 -0.53,-1.25 -0.64,-3.32 0.66,-4.22 0.16,-1.61 -2.44,-1.55 -3.38,-2.41 -1.36,-1.1 -1.24,-3.29 -1.94,-4.84 -0.61,-1.65 0.81,-2.5 1.63,-3.59 0.63,-2.01 -1.93,-3.01 -2.94,-4.25 -0.58,-0.62 0.09,-2.1 0.84,-1.31 0.74,0.86 2.21,1.23 2.16,2.56 0.75,0.45 1.5,0.92 1.66,1.94 0.49,1.17 0.05,2.74 1.22,3.5 1.3,2.22 4.13,3.33 6.59,3.59 1.85,-0.29 2.83,-3.63 4.84,-2.56 -1.06,1.72 -1.31,4.21 -0.03,5.91 0.53,0.64 1.86,-0.09 1.5,1.16 0.19,1.19 1.81,3.41 2.97,2.03 0.56,-0.64 1.17,-0.02 1.59,0.38 1.77,-0.9 0.6,-3.49 1.78,-4.88 0.78,-1.32 2.02,-2.48 1.94,-4.09 1.7,0.15 1.04,2.38 0.31,3.28 -0.15,1.22 0.88,2.46 -0.06,3.59 -0.81,1.08 -0.53,2.89 1.03,2.94 1.84,0.19 4.21,0.72 5.44,-1 2.03,-1.31 4.47,-2.23 6.38,-3.75 1.67,-0.03 0.6,-1.92 -0.28,-2.34 -0.86,-0.66 -0.5,-1.33 0.31,-1.72 0.28,-1.61 2.13,-2.57 2.13,-4.28 1.29,0.5 0.96,2.61 2.31,3.31 1.57,1.33 3,-0.86 3.97,-1.88 1.05,-0.81 2.45,-1.24 3.59,-0.47 1.63,-0.02 3.22,0.63 4.81,0.56 0.47,-0.61 0.74,-1.31 1.53,-1.69 1.7,-1.99 -1.39,-4.09 -0.47,-6.25 0.21,-2.96 1.04,-6.26 -0.78,-8.88 0.32,-0.89 1.46,0.53 1.66,1.03 0.72,1.9 0.94,4.71 3.19,5.44 1.55,0.1 4.58,0.6 4.91,-1.53 -0.61,-1.56 2.14,-1.56 2.53,-0.34 1.79,1.55 4.41,1.33 6.5,0.69 1.54,0.49 3.14,1.7 4.78,0.78 2.26,-0.85 4.57,-0.36 6.75,0.34 1.28,-0.08 2.27,-1.13 3.63,-1.03 1.9,-0.4 3.02,-2.15 3.03,-3.97 0.69,-1.22 1.38,-2.97 -0.06,-3.94 -0.74,-1.32 1.42,-1.3 2.19,-1.13 1.83,0.17 4.02,1.13 5.13,-0.94 1.38,-1.33 3.07,-2.22 3.94,-4.03 1.08,-1.22 2.74,-2.02 3.13,-3.81 0.77,-1.4 2.71,-0.64 3.72,-1.88 1.53,-1.39 3.71,-1.96 5.03,-3.53 1.14,-1.34 1.27,-3.67 2.78,-4.56 1.96,-0.05 2.42,-3.02 1.16,-4.03 -0.24,-1 1.36,-1.03 1.41,-2.13 1.16,-1.7 3.17,-2.64 4.22,-4.47 1.16,-1.09 3.09,-1.21 3.66,-2.97 0.59,-1.89 2.9,-1.35 4.19,-2.34 1.44,-0.35 2.46,0.73 3.63,1.19 2.1,-0.62 3.3,-2.79 3.19,-4.91 0.07,-1.24 0.79,-2.25 2.03,-2.38 1.66,-1.01 3.15,-2.54 5.25,-2.34 1.82,-0.34 3.73,-2.33 3.41,-4.19 -0.6,-0.49 -1.73,-0.25 -1.69,-1.31 -0.52,-2 -2.13,-3.59 -1.72,-5.81 -0.15,-3.08 -4.28,-4.1 -4.19,-7.25 -0.46,-1.15 -1.29,-2.06 -1.88,-3.13 -1,-0.87 -0.47,-2.58 0.97,-2.56 1.35,-0.34 2.96,0.75 4.13,-0.53 1.99,-1.82 2.74,-4.77 4.78,-6.44 -0.33,-1.11 0.47,-2.04 1.5,-2.28 0.54,-0.6 0.4,-1.78 1.56,-1.59 1.49,-0.39 1.23,-2.51 2.78,-2.72 1,-1.06 -0.66,-2.92 1,-3.66 0.84,-0.67 2.35,-1.15 1.59,-2.53 -0.72,-1.79 -1.56,-3.54 -2.19,-5.34 -0.78,-1.14 -2.6,-0.62 -3.13,-2.16 -0.78,-0.82 -0.08,-2.79 -1.75,-2.69 -1.8,-0.11 -3.12,-1.55 -4.72,-2.03 -1.09,0.41 -2.07,1.3 -3.34,0.69 -2.77,-0.25 -5.28,-1.34 -7.38,-3.09 -1.59,-1.83 -3.6,-3.36 -5.75,-4.34 -0.71,-0.98 -2.28,-0.71 -3.19,-1.59 -1.16,-0.46 -1.68,1.5 -2.84,0.41 -1.01,-0.32 -2.42,1.01 -2.94,-0.47 -0.24,-1.09 1.11,-2.33 -0.34,-3.13 -0.78,-1.19 -1.49,-2.68 -3.13,-2.81 -3.07,-0.57 -6.29,-0.49 -9.38,-0.69 -1.59,0.37 -1.93,2.34 -3.59,2.69 -1.29,0.72 0.13,1.7 0.47,2.38 -0.91,0.75 -2.38,1.24 -2.44,2.69 -0.88,3 -4.75,1.91 -6.56,3.88 -1.84,0.97 -4.01,1.05 -5.94,1.75 -2.68,-0.63 -4.39,-2.97 -6.59,-4.38 -3.37,0.07 -7.15,1.04 -10.38,-0.38 -0.9,-0.85 -2.18,-1.78 -3.31,-0.69 -1.53,1.03 -3.26,-0.6 -4.94,-0.38 -3.55,-0.11 -6.82,-1.31 -10.03,-2.66 -1.78,-0.71 -3.4,2.02 -5.06,0.38 -0.81,-0.42 -0.67,-2.16 -1.84,-1.28 -0.71,0.49 -2.72,0.73 -2.31,-0.75 0.45,-3.32 -2.49,-5.51 -4.84,-7.22 -1.24,-0.35 -2.46,-0.35 -3.59,-1.03 -1.27,0.26 -1.07,-1.61 -0.72,-2.16 1.94,-0.41 3.96,0.79 5.44,1.72 1.51,2.41 4.24,3.4 5.97,5.59 1.92,1.84 4.69,-0.15 6.94,-0.06 1.43,-0.68 2.33,0.42 3.34,1.19 0.99,0.6 2.18,0.35 3.06,1.13 2.23,-0.03 4.2,2 6.38,1.59 0.9,-1.48 3.22,-0.24 4.16,-1.88 0.74,-0.6 2.03,0.03 2.63,-1.06 1.35,-0.84 3.13,-1.73 4.66,-1 1.67,-0.68 4.24,-0.46 4.66,-2.72 0.5,-1.71 0.26,-4.61 2.53,-4.84 1.28,-1.08 2.43,-2.25 3.72,-3.31 1.59,-1.75 3.76,-2.73 5.16,-4.72 1.78,-2.57 5.95,-2.77 8.09,-0.59 1.56,1.91 4.6,0.96 6.25,-0.38 2.95,-1.28 6.11,-2.3 8.31,-4.81 1.05,-1.44 3.08,-1.97 3.88,-3.53 -0.04,-1.22 -1.85,-0.71 -2.38,-1.72 -1.36,-0.6 -1.67,-2.27 -3,-2.75 -0.73,-0.12 -1.23,-1.05 -2.22,-0.78 -2.05,-0.26 -4.28,-0.62 -5.75,-2.06 -1.03,-0.1 -1.42,-1.72 -2.66,-1.22 -1.25,-0.4 -2.54,-0.8 -3.75,-1.19 -0.37,-1.33 2.07,-1.07 2.81,-1.56 2.85,-1.01 2.63,-4.88 2.69,-7.25 -1.48,-0.34 -3.46,0.95 -4.59,-0.66 -1.82,-1.22 -3.82,0.24 -4.97,1.66 -1.45,0.64 -2.74,1.72 -4.44,1.78 -2.05,0.8 -3.62,2.4 -5.81,3.03 -3.42,1.49 -6.4,3.93 -10.19,4.41 -2.69,0.88 -5.29,-1.28 -6.69,-3.38 1.26,-0.43 2.59,1.32 3.75,1.84 1.73,0.46 3.16,-1.23 4.84,-1.41 4.18,-2.75 6.8,-7.61 11.56,-9.41 0.96,-0.58 1.55,0.09 2.31,0.44 2.96,0.33 5.36,-2.1 8.38,-1.66 2.85,0.31 5.56,-2.62 8.34,-1.03 0.77,0.56 2.83,1.9 3,0.09 -0.3,-1.86 1.03,-3.2 2.63,-3.91 2.18,-1.05 3.55,-3.18 5.22,-4.69 2.04,-0.85 4.34,-1.59 5.22,-3.84 0.56,-1.43 2.95,-2.92 2.06,-4.59 -1.51,-1.71 -0.75,-4.69 1.38,-5.56 0.83,-0.35 3,-1.38 1.63,-2.38 -2.06,-0.53 -4.76,0.49 -6.06,-1.78 -1.1,-1.17 1.31,-0.92 1.81,-1.56 1.14,0 3.21,-0.32 3.47,1.19 1.43,0.83 1.31,-1.79 1.66,-2.63 0.31,-2.35 2.16,-4.4 4.44,-5 1.87,-1.47 4.61,-2.49 5.34,-4.94 -0.46,-0.18 -0.96,-0.29 -1.47,-0.34 0.83,-0.11 1.66,-0.27 2.47,-0.5 0.82,-0.43 -0.06,-1.68 1.09,-1.81 2.44,-1.86 3.44,-4.84 4.28,-7.63 0.41,-2.17 -0.71,-4.62 0.16,-6.66 1.61,-1.84 1.86,-4.53 3.5,-6.31 0.13,-1 1.61,-1.18 1.59,-2.34 1.99,-2.67 3.44,-5.89 4.41,-9.06 -0.01,-1.18 -2.11,-0.28 -1.5,-1.56 0.23,-1.31 0.44,-2.9 -0.75,-3.84 2.1,-2.95 2.53,-6.83 4.31,-10 0.91,-2.31 3.06,-5 1.78,-7.53 -1.27,-0.77 -0.47,-2.54 -1.03,-3.72 1.28,-0.04 2.62,1 2.13,2.41 -0.34,1.3 1.1,1.87 1.78,0.75 2.05,-2.51 4.97,-4.38 6.5,-7.28 -0.31,-1.47 0.99,-1.93 2,-2.5 1.1,-1.17 1.03,-3 2.5,-4 0.98,-0.77 1.02,-2.06 0.09,-2.84 -0.25,-1.41 0.94,-3.26 -0.56,-4.25 -0.35,-2.09 -0.07,-4.44 -1.47,-6.19 -0.84,-1.78 0.72,-4.64 -1.78,-5.44 -2.54,-0.85 -3.38,-3.43 -4.72,-5.44 -1.33,-1.65 -4.49,0.26 -5.41,-1.91 -0.62,-1.67 -2.74,-0.17 -3.94,-1.03 -1.5,-0.59 -3.14,-0.14 -4.59,0.09 -1.13,1.57 -3.37,2.94 -5.31,2.31 -1.7,-0.94 -4.01,-0.1 -5.53,-1.53 -0.98,-0.67 -2.05,-0.07 -2.13,0.94 -2.14,1.97 -5.55,0.86 -8.22,1.16 -1.6,0.04 -3.55,-0.8 -4.59,0.88 -2.64,-1.43 -6.14,-1.87 -9.22,-2.28 -1.64,0.1 -3.33,-0.78 -4.88,-0.34 -1.13,1.13 -2.41,-1.01 -3.72,-0.81 -1.74,-0.31 -3.79,0.2 -5.09,-1.13 -2.98,-0.12 -5.59,2.09 -8.31,3.06 -1.63,0.94 -3.45,1.59 -5.28,0.84 -0.97,-0.59 -1.96,1.16 -2.66,0.22 -1.87,-2.07 -5.09,-2.13 -7.44,-3.53 -1.88,-0.81 -3.75,-1.88 -5.47,-2.81 -3.59,-0.22 -7.08,0.86 -10.47,1.78 -1.36,0.47 -2.54,1.4 -2.66,2.88 -1.26,2.17 -3.95,2.35 -6.16,2.56 -0.92,0.73 1.02,2.03 -0.16,2.81 -1.33,0.09 -3.86,0.66 -4.41,-1 -0.02,-0.88 2,-0.91 0.88,-1.88 -1.75,-0.51 -3.54,0.19 -4.63,1.56 -1.67,1.48 -4.01,1.68 -5.47,3.47 -3.42,3.13 -8.38,3.35 -12.78,3 -1.04,-0.34 -2.04,-1.09 -3.13,-0.31 -0.74,-0.17 -1.95,-0.04 -1.47,1.06 1.52,2.24 -1.21,3.76 -2.84,4.69 -1.5,0.57 -0.83,2.9 -2.59,3 -1.65,0.63 -1.9,2.78 -3.72,3.25 -1.27,0.51 -2.48,-1.55 -3.59,-0.38 -2.3,-0.31 -4.42,1.14 -6.78,0.78 -1.67,-0.09 -3.9,0.46 -4.88,-1.34 -1.11,-0.37 -1.42,1.56 -2.66,1.5 -0.77,0.42 -1.85,0.26 -1.09,-0.72 0.89,-0.77 2,-1.38 2.81,-2.31 1.92,-1.54 4.42,-1.04 6.53,-0.28 1.81,0.17 3.66,0.06 5.44,0.31 0.82,-1.02 2.06,-1.94 2.63,-3.16 -0.49,-1.39 -3.12,-0.76 -3.53,-2.06 1.61,-0.83 4.68,1.02 5.25,-1.47 0.94,-1.38 2.54,-1.83 3.84,-2.53 0.98,-3.94 4.72,-6.32 7.13,-9.38 0.3,-1.64 -2.07,-0.81 -2.81,-0.41 -2.29,1.03 -4.89,2.14 -7.41,1.66 -0.4,-0.82 -0.86,-1.76 -2.06,-1.5 -3.69,0.26 -6.14,3.56 -8.91,5.66 -2.16,1.88 -4,4.26 -6.53,5.59 -0.34,0.71 -1.53,0.95 -1,-0.16 0.97,-1.18 1.13,-2.69 1.66,-4 2.16,-1.72 3.92,-3.95 6.22,-5.47 1.59,-0.24 0.42,-2.36 1.91,-2.81 1.64,-0.52 3.39,-0.6 5,-1.28 1.85,-0.22 3.99,0.47 5.44,-1.13 1.89,-1.46 3.36,-3.9 6.03,-3.78 0.82,0.09 2.3,-0.54 2.84,0.13 0.12,1.34 -1.7,3.13 0.03,4.09 2.39,1.04 3.9,-2.03 4.88,-3.69 1.76,-4.1 5.93,-6.6 7.63,-10.69 -0.75,-1.4 -2.43,0.6 -3.53,0.53 -1.73,0.41 -3.77,1.01 -5.41,0.91 0.16,-0.97 2.04,-1.63 0.75,-2.69 -1.96,-1.36 -3.83,1.36 -5.56,2 -1.79,1.79 -3.25,-1.05 -5.09,-1.16 -1.46,-0.1 -3.72,0.57 -4.66,-0.78 -0.79,-1.64 -2.56,-3.07 -4.38,-2.03 -1.8,0.47 -4.18,1.01 -5.53,-0.66 -1.42,-0.73 -3.44,-1.78 -2.97,-3.69 -0.49,-0.96 -1.91,-0.58 -2.34,-1.75 -0.54,-0.5 -0.99,-2.29 0.19,-1.81 0.91,1.21 2.83,1.45 3.34,3.09 1.25,1.61 3.36,3.85 5.56,2.63 2.28,-0.5 4.79,-0.16 6.88,0.88 0.89,0.01 0.86,-1.99 1.81,-0.94 0.47,1 1,2.62 2.31,1.16 1.42,-1.26 3.78,0.01 4.97,-1.44 0.42,-1.86 2.39,-3.96 1.06,-5.81 -0.96,0.07 -2.01,0.36 -2.94,-0.34 -1.24,-0.56 -2.66,-2.04 -2.31,-3.38 1.71,-0.34 3.24,1.56 5.06,0.84 1.49,-0.28 1.4,-2.19 2.84,-2.66 1.86,-1.57 4.57,-1.17 6.25,-2.97 1.5,-0.52 1.93,-1.95 2.34,-3.34 1.04,-2.11 2.9,-4.06 5.31,-4.31 2.67,-1.49 4.98,-3.46 7.38,-5.34 1.41,-0.38 2.16,-1.65 3.47,-2.34 1.99,-1.53 4.02,-2.99 6,-4.5 0.75,-1.04 1.66,-1.87 2.47,-2.75 0.61,-2.09 2.19,-3.97 3.59,-5.53 1,-0.39 1.2,-1.77 2.31,-2.22 1.75,-1.5 3.82,-2.33 5.94,-3 1.84,-1.43 4.59,-0.65 6.16,-2.66 0.97,-1.09 1.81,-2.37 2.69,-3.5 -0.08,-0.11 -0.18,-0.21 -0.28,-0.28 1.63,-0.36 2.88,-1.76 4.06,-2.88 0.48,-2.33 1.81,-4.61 1.78,-7.03 -0.69,-0.68 -0.05,-0.98 0.66,-1.03 1.37,-0.54 1.48,-3.36 -0.41,-3.03 -1.42,0.18 -3.19,-0.19 -3.31,-1.88 -0.56,-1.97 -0.55,-4.34 1.28,-5.63 1.44,-1.57 3.66,-3.68 2.5,-5.97 0.43,-0.98 2.3,-1 2.06,-2.5 -0.14,-1.12 0.94,-3.12 -0.91,-3.22 -2.5,-0.78 -4.91,0.99 -7.31,0.5 -0.49,-1.41 -1.85,-2.14 -3.22,-1.44 -1.93,0.12 -3.93,0.12 -5.72,0.78 -1.24,-0.28 -3.28,0.42 -3.69,-1.22 -0.27,-0.66 -0.69,-1.62 -1.56,-1.5 z m -193.38,18.16 c -0.84,0.22 -0.42,1.38 -1.19,1.78 -0.87,1.03 -2.02,1.72 -3.31,1.97 -1.12,0.9 -1.85,2.28 -3.38,2.63 -2.35,0.99 -4.1,2.86 -6.03,4.44 -1.11,0.7 -1.94,1.82 -3.19,2.22 -1.07,0.86 -1.21,2.59 -2.38,3.28 -2.33,0.01 -3.81,2.31 -6.13,2.31 -0.39,-0.36 -1.27,-0.9 -1.59,0 -0.16,0.8 -1.25,1.05 -1.63,1.72 -1.46,-0.39 -2.36,1.15 -3.19,2 -0.77,0.3 -1.3,0.93 -2.22,0.69 -1.07,-0.08 -2.5,1.7 -1.41,2.44 0.29,0.11 1.62,-0.09 1.22,0.47 -0.97,0.56 -2.69,1.26 -1.91,2.72 0.5,0.39 0.68,0.88 0.91,1.47 0.57,0.69 1.57,0.94 1.81,1.91 0.33,0.76 1.91,1.02 1.56,2.03 -0.77,0.77 0.36,1.45 1.03,1.66 0.41,0.42 1.65,0.98 0.88,1.59 -0.02,0.58 0.24,1.58 -0.69,1.53 -1.07,0.41 -1.34,-0.66 -1.66,-1.41 -0.64,-1.23 -2.28,-0.88 -3.28,-1.69 -1,-0.37 -2.4,-1.11 -3.19,-0.09 -0.92,0.05 -1.11,0.96 -1,1.69 -0.61,0.43 -0.46,1.26 -1.16,1.56 -0.82,1.68 0.94,3.24 0.91,4.94 0.12,0.49 0.23,1.52 -0.47,0.75 -1.07,-0.8 -0.83,-2.34 -1.5,-3.41 -0.62,-1.36 0.56,-3.71 -1.31,-4.28 -1.55,-0.04 -3.04,-1.1 -3.78,-2.41 0.63,-0.26 2.09,0.19 1.84,-1 -0.2,-1.05 -1.17,-0.98 -1.81,-0.53 -1.43,-0.24 -2.48,-1.82 -4.09,-1.41 -0.92,-0.13 -1.17,0.76 -1.16,1.44 -0.56,0.43 0.09,1.14 -0.47,1.56 -0.28,1.47 1.68,0.58 2.31,1.34 0.45,0.27 0.83,1.19 0.16,1.38 -0.78,-0.73 -1.5,0.17 -1.78,0.81 -1.05,-0.48 -2.2,-1.31 -3.41,-1 -1.01,0.91 1.11,1.41 0.38,2.44 -0.63,1.15 -1.24,2.57 -2.38,3.25 -0.54,1.32 1.52,1.83 1.25,3.16 0.61,1.22 0.31,2.82 1.25,3.88 1.31,0.66 2.77,-0.5 3.72,-1.19 0.52,0.37 1.23,1.3 0.31,1.66 -0.66,0.85 0.56,1.5 0.94,2.16 1.58,0.24 3.11,-0.76 4.72,-0.72 0.68,0.06 1.78,-0.42 2.28,0.09 0.25,1.02 -1.29,0.32 -1.81,0.66 -1.09,0.23 -1.89,1.34 -3.09,0.91 -1.58,0.34 -3.36,1.01 -4.31,2.38 -0.28,0.56 -0.17,1.76 -1.13,1.22 -0.44,-0.4 -1.12,-1.48 -1.56,-0.41 0.1,1.49 0.17,3.7 1.75,4.38 0.74,0.64 1.29,2.06 2.56,1.69 0.73,-0.12 0.6,-1.48 1.53,-0.81 1.73,0.9 3.7,2.01 5.69,1.63 0.73,-0.47 1.08,0.16 0.78,0.84 0.63,1.51 2.79,0.44 3.88,1.22 1.04,0.78 -1.42,1.33 -0.34,2.16 0.99,0.34 1.83,0.95 2.56,1.59 1.13,0.2 2.72,-0.44 3.56,0.53 0.91,1.03 2.59,0.66 3.78,1.22 1.26,0.51 2.04,-1.22 0.97,-1.94 -0.46,-0.85 -2.09,-0.71 -2.16,-1.69 0.72,-0.37 2.73,-0.08 2.03,-1.38 -0.44,-0.88 -1.27,-1.42 -1.75,-2.19 -0.62,-0.45 -2.04,0.11 -2.25,-0.78 0.24,-0.56 1.3,-0.47 1.09,-1.38 -0.02,-1.25 -0.87,-2.62 -1.97,-3.03 -0.21,-0.87 -0.11,-1.86 0.97,-2.03 1.87,-0.86 2.63,-2.97 4.38,-4 0.63,-1.23 -1.3,-0.56 -1.38,-1.41 0.62,-0.64 1.94,-0.13 2.78,-0.28 1.53,0.18 3.35,0.08 4.69,0.81 0.18,0.76 -1.2,0.43 -1.59,0.69 -0.71,0.44 -1.24,0.14 -1.69,-0.44 -0.7,-0.7 -2.03,-0.08 -1.66,0.91 -0.33,1.04 -1.67,0.96 -2.09,2 -0.84,0.84 -1.27,2.03 -0.66,3.13 0.12,1.18 -0.96,2.51 0.19,3.5 1.18,1.46 1.49,3.57 2.94,4.78 1.32,0.52 2.17,-1.2 1.38,-2.19 -0.23,-0.55 -1.29,-1.81 -0.5,-2.22 0.91,0.36 1.55,1.33 2.44,1.72 0.01,1.34 0.87,2.92 2.41,2.75 0.53,0.29 1.44,1.16 1.69,0.06 0.1,-1.01 -0.77,-1.75 -0.44,-2.81 -0.2,-0.55 0.25,-1.57 0.56,-0.66 0.29,1.01 1.51,2.47 2.59,1.59 0.84,-0.08 2.28,0.09 2.16,-1.19 -0.36,-1.33 1.64,-2.21 0.91,-3.44 -0.16,-0.8 -0.33,-1.97 -1.47,-1.84 -2.27,-0.37 -4.74,0.21 -6.94,-0.47 -0.65,-0.7 0.96,-0.5 1.28,-0.66 0.97,-0.02 1.93,-0.52 2.53,-1.16 0.52,0.63 1.4,0.82 1.91,0.16 0.84,0.45 1.73,0.24 2.38,-0.41 0.58,0.19 1.22,0.97 1.84,0.28 1.17,0.54 2.79,1.42 3.78,0.06 0.84,-0.56 1.67,-2.37 0.09,-2.5 -0.76,-0.35 -2.46,0.3 -2.69,-0.81 0.33,-0.68 1.66,-0.12 2.28,-0.63 0.82,-0.23 0.89,-1.19 0.31,-1.66 0.13,-0.87 -0.37,-1.68 -1.22,-1.81 -0.36,-0.68 -0.42,-2.38 -1.44,-1.38 -0.32,0.41 -0.89,1.08 -1.31,0.41 -0.82,-0.35 -1.88,-0.12 -2.59,0.22 -0.91,-0.65 -2.02,-0.33 -2.84,0.28 -1.06,0.21 -2.32,0.17 -3.03,1.09 -0.6,-0.09 -1.05,-1.15 -0.84,-1.63 0.74,-0.6 1.86,-0.3 2.47,-1.09 1.91,-0.7 4.6,0.1 5.97,-1.72 0.61,-0.89 -0.41,-1.27 -1.09,-1 -0.5,-0.31 -0.35,-1.3 -1.22,-1.25 -0.39,-0.18 -1.21,-1.26 -0.19,-0.94 1.35,-0.08 2.54,1.04 3.84,0.78 0.88,-1.21 2.61,-1.01 3.72,-1.84 0.34,-1.37 -0.93,-2.63 -0.81,-4.03 0.03,-0.63 -0.82,-1.43 -0.47,-1.97 0.76,-0.11 1.92,-0.37 2.47,0.25 0.18,1.29 1.39,1.62 2.03,0.38 0.99,-0.58 0.79,-2.16 -0.47,-2.13 -0.95,-0.24 -2.25,0.15 -3.03,-0.34 -0.24,-0.83 1.3,-0.77 0.81,-1.72 0.43,-0.9 2.5,0.26 2.56,-1.38 0.28,-0.76 -0.29,-2.56 0.97,-2.59 0.74,0.23 1.94,0.21 1.84,-0.88 -0.43,-1.27 0.83,-1.94 1.91,-2 0.79,-0.11 0.75,-0.96 0.72,-1.5 0.69,-0.31 0.58,-1.26 1.47,-1.34 0.74,-0.88 1.6,-1.81 2.31,-2.72 -0.23,-1.17 -2.32,-1.99 -1.5,-3.5 0.32,-1.38 1.19,-2.53 1.66,-3.81 0.93,-0.67 1.52,-2.02 0.53,-2.94 -1.13,-0.79 -1.15,-2.41 -0.66,-3.44 -0.41,-1.35 -2.09,-1.91 -2.56,-3.16 0.36,-1.21 -1.17,-1.45 -2,-1.59 z m 5.63,29.22 c -1.37,0.27 -2.52,1.48 -3,2.72 -1.16,0.93 -3.2,0.9 -3.75,2.5 0.22,1.5 2.12,3.08 3.56,1.91 0.9,-0.32 0.5,-1.53 1.5,-1.69 1.36,-0.28 2.67,-1.23 2.5,-2.78 0.03,-0.84 0.92,-2.68 -0.59,-2.66 l -0.22,0 z m -49.25,39.16 c -0.13,-0 -0.25,0.02 -0.38,0.03 -0.94,0.32 -2.14,1.2 -2.09,2.28 0.77,0.84 2.43,1 2.91,2.09 -0.38,0.99 -1.6,0.39 -2.34,0.34 -1.45,0.03 -3.49,0.08 -3.91,1.81 -0.89,1.96 -3.51,2.19 -4.44,4.03 -0.16,0.67 -0.68,1.28 -0.25,2.03 0.38,1.77 2.47,1.99 3.69,2.84 0.1,1.92 2.33,3.65 4.19,3.16 0.58,-0.6 0.29,-2.01 1.5,-2.03 0.96,0.28 1.34,-0.99 0.41,-1.28 -0.34,-0.82 0.74,-1.48 1.47,-1.16 1.01,-0.28 0.73,-1.78 1.78,-2.06 0.73,-0.39 0.13,-1.53 1.03,-1.59 0.85,-0.85 -0.79,-1.45 -0.75,-2.13 1.02,-0.41 2.28,0.06 2.56,1.19 0.43,1.07 2.09,0.93 2.09,-0.31 -0.04,-0.55 -0.07,-1.42 0.69,-1 0.93,0.82 2.51,-0.34 1.63,-1.41 -0.61,-0.38 -0.4,-1 -0.69,-1.5 -0.68,-0.33 -1.67,-0.07 -2.09,-0.94 -0.35,-0.59 -1.11,-1.64 -0.09,-2.03 0.88,-1 -0.7,-1.64 -1.53,-1.44 -1.46,-0.02 -3.02,0.19 -4.25,-0.72 -0.36,-0.11 -0.74,-0.21 -1.13,-0.22 z m 39.16,23.63 c -1.41,0.52 -0.66,2.57 -1.91,3.38 -0.69,1.12 -2.01,1.13 -2.97,1.75 -1.22,1 -0.95,2.66 0.03,3.69 0.76,1.1 -0.11,3.64 1.97,3.41 1.64,-0.1 0.08,1.84 -0.09,2.53 -0.39,0.83 -1.46,1.37 -0.69,2.41 0.8,1.84 1.4,3.8 3.09,5.06 0.55,0.75 2.01,1.68 1.75,2.66 -1.31,0.77 0.45,2.09 -0.28,2.91 -1.59,0.59 -1.49,-1.4 -1.81,-2.34 -0.58,-0.46 -0.88,-0.91 -1,-1.66 -0.92,-1.63 -3.99,-2.58 -4.63,-0.22 -0.43,0.76 -0.2,1.79 -0.25,2.5 -1.27,-0.01 -1.86,-1.43 -1.78,-2.5 -1.51,-2.15 -3.46,-4.21 -5.72,-5.56 -1.54,0.47 -2.59,-1.21 -2.38,-2.59 -0.34,-1.8 -1.52,-3.67 -3.38,-4.13 -0.74,1.47 -0.72,3.6 -0.66,5.25 1.62,1.87 4.04,3.26 5.22,5.41 0.07,0.81 -0.73,2.11 -1.56,1.22 -0.83,-1.43 -3.07,-0.62 -2.75,0.97 0.28,1.38 0.9,2.62 1.88,3.56 0.56,1.11 1.99,3.11 0.63,4.09 -1.26,0.09 -0.22,-2.46 -1.81,-1.78 -1.23,1.01 -2.12,-1.19 -3,-1.78 -1.52,-1.92 -2.4,-4.43 -4.56,-5.81 -1.52,-0.07 -1.03,2.28 -0.94,3.28 0.09,1.11 1.54,1.74 1.53,2.72 -1.19,0.64 -2.19,-0.28 -3.16,-0.69 -1.45,0.7 -0.73,2.95 0.72,3.25 1.68,1.18 1.58,3.39 2.22,5.09 2.35,2.43 5.88,3.06 8.75,4.66 1.66,0.47 1.05,-1.98 1.06,-2.91 -0.24,-1.2 -0.94,-3.31 1.03,-3.22 1.08,-0.16 0.53,-2.13 1.5,-2 0.69,0.48 1.33,2.35 2.31,1.19 0.76,-1.39 1.51,0.84 1.38,1.56 0.13,0.9 1.33,0.92 1.16,1.94 0.42,1.45 2.18,2.99 3.44,1.41 0.41,-0.72 2.46,-1.24 1.75,0.09 -1.56,0.79 0.34,2.51 1.13,3.09 0.99,1.28 1.97,2.78 3.69,3.13 1.12,0.87 -0.95,1.16 -1.59,1 -2.16,-0.42 -2.95,-3.61 -5.16,-3.72 -0.86,1.27 -2.68,0.86 -3.66,2.13 -1.27,1.12 0.58,1.97 0.97,2.94 0.13,1.66 1.23,2.89 2.19,4.13 0.67,2.08 3.97,1.17 4.69,-0.5 1.02,-0.58 0.68,1.49 0.63,2 -0.01,1.61 -2.74,0.47 -2.31,2.28 0.56,1.11 1.43,2.85 2.69,2.94 0.99,-0.37 2.41,-2.31 3.53,-1.44 0.58,1.06 -0.32,2.08 -0.44,3.06 1.14,1.15 3.02,-0.33 4.38,-0.38 1.09,-0.71 2.74,0.58 3.47,-0.59 -0.1,-0.85 -0.02,-2.84 1.31,-2.09 0.72,0.96 1.71,0.94 2.84,0.84 1.41,1.38 0.33,3.84 0.84,5.59 0.1,1.49 1.75,0.58 1.88,-0.44 0.8,-1.07 0.68,-2.59 1.31,-3.63 1.3,-0.31 1.93,-1.69 1.19,-2.88 -0.19,-0.79 -1.37,-2.33 0.03,-2.56 1.45,1.76 2.74,3.82 3.19,6.03 1.31,0.72 2.94,-0.57 4.41,-0.25 1.21,-0.36 2.4,-0.35 3.59,-0.63 0.59,-0.13 1.94,-1.38 2.28,-0.53 -1.61,2.78 -5.38,2.51 -7.38,4.88 -1.66,0.81 -3.36,2.43 -2.84,4.44 -1,0.87 -1.28,2.2 -1.09,3.53 -0.2,1.06 -2.13,1.12 -1.81,2.56 0.14,1.31 1.05,3.78 2.75,2.69 2.99,-1.08 5.87,-3.29 6.84,-6.38 1.11,-0.45 1.14,-1.66 1.66,-2.56 0.68,-1.32 2.55,-0.06 3.06,-1.59 1.07,-1.97 0.17,-4.68 1.06,-6.53 1.51,1.8 3.65,-0.41 5.19,-1.06 2.36,-1.17 3.8,-3.49 3.97,-6.09 0.46,-0.85 0.72,-2.45 -0.78,-2.19 -1.47,-0.13 -3.56,0.96 -4.5,-0.66 -2.07,-0.72 -4.04,1.34 -5.94,1.91 -1.62,0.69 -3.95,2.52 -5.53,0.97 0.01,-1.14 -0.83,-2.13 -2.06,-1.91 -1.1,-0.37 -2.09,-1.11 -3.34,-1.13 -0.87,-0.63 -2.09,-2.49 -3.13,-1.06 -0.72,0.73 -2.54,2.17 -3.16,0.72 0.66,-1.2 3.47,-2.83 1.63,-4.22 -2.02,-0.71 -4.29,-0.18 -5.88,1.16 -0.56,0.34 -2.26,0.26 -1.03,-0.59 0.86,-1.59 3.4,-1.65 3.78,-3.47 -0.52,-1.05 -1.64,-1.93 -2.03,-3.19 -0.48,-0.73 -0.86,-1.82 0.19,-2.19 1.26,-1.53 -0.87,-3.78 -2.47,-2.47 -0.54,0.18 -1.51,1.84 -2,0.97 -0.43,-1.7 0.76,-3.11 2.34,-3.53 1.7,-1.24 2.12,-3.95 1.44,-5.81 -0.66,-2.23 0.15,-4.87 0.03,-7.22 0.23,-3.01 -0.83,-5.85 -2.25,-8.44 -0.13,-1.89 -2.34,-2.17 -3.78,-2.47 -0.99,-1.07 -0.25,-3 -1.56,-4.03 -1.01,-1.49 -2.85,-2.09 -4,-3.31 -0.18,-0.05 -0.35,-0.06 -0.53,-0.03 z m -68.44,4.34 c -1.73,0.29 -0.41,3.61 -2.38,3.16 -1.16,0.03 -2.03,-0.6 -2.59,-1.56 -1.11,-0.79 -3.64,-2.65 -3.91,-0.19 -0.35,2.22 -2.48,3.73 -2.31,6 0.62,1.21 2.28,-1.05 2.59,0.69 -0.27,1.17 0.66,2.99 1.94,1.81 0.71,-0.45 0.21,-2 1.44,-1.56 1.16,-0.07 1.72,0.73 2.13,1.66 1.42,1.48 3.74,1.87 5.56,1.84 0.42,1.22 -2.28,0.83 -1.09,2.06 1.14,0.3 1.34,2.04 2.72,2.16 1.83,1.06 4.78,0.65 5.13,-1.78 0.39,-1.06 -0.69,-1.62 -1.41,-1.75 -0.2,-1.62 1.73,-1.89 2.94,-1.59 1.56,0.1 3.58,1.06 4.59,-0.78 0.97,-1.2 -0.55,-2.29 -1.69,-1.59 -0.81,0.17 -3.34,-0.54 -1.91,-1.5 1.35,-1.08 -0.81,-1.71 -1.59,-2.16 -0.56,-0.5 -0.38,-1.45 -1,-1.97 0.23,-1.21 -0.78,-2.16 -1.97,-1.63 -1.1,-0.1 -2.09,1.31 -3.06,1.06 -1.18,-0.94 -2.66,-1.47 -3.78,-2.38 -0.11,-0.01 -0.24,-0.02 -0.34,0 z m -1.75,34.91 c -1.58,0.87 -0.57,3.27 -0.97,4.72 0.14,2.15 -1.68,3.63 -1.84,5.75 -1.3,4.89 0.79,9.77 1.63,14.53 0.77,1 0.5,2.76 2.06,3.13 2.34,0.9 5.22,-1.45 7.28,0.47 1.18,0.88 2.38,-1.19 0.88,-1.56 -0.42,-1.76 -2.43,-3.03 -4.16,-2.16 -1.31,0.43 -2.78,0.17 -3.13,-1.38 -0.81,-0.95 0.96,-1.42 1.03,-2.41 1.42,-0.51 2.47,1.81 3.94,1.84 1.99,0.1 2.14,-2.71 1.03,-3.88 -0.74,-0.96 -0.09,-3.01 -1.88,-2.88 -1.1,-0.11 -1.98,-0.99 -3.16,-0.97 -1.12,-0.1 -2.35,-1.92 -1.47,-2.72 1.06,0.1 1.69,1.94 2.91,0.91 0.95,-1.12 1.76,-0.05 2.44,0.72 1.42,0.12 1.38,-2.25 1.78,-3.34 0.66,-1.38 1.83,-2.49 3.09,-3.16 0.6,-1.26 -1.44,-0.87 -1.25,-2.06 -0.45,-1.91 -2.95,-1.31 -4.06,-2.66 -1.15,-1.2 -2.63,-1.87 -4.19,-2.25 -0.53,-0.46 -1.26,-0.72 -1.97,-0.66 z m 69.72,34.53 c -1.13,0.82 -2.86,0.37 -3.81,1.69 -1.06,1.14 -2.57,2.09 -3.09,3.59 0.86,1.86 3.1,2.58 4.38,4 0.17,1.37 1.2,2.16 2.31,2.81 0.59,1.09 1.85,1.24 2.5,0.13 1.96,-1.47 3.92,-4.21 2.72,-6.69 -0.51,-0.36 -2.72,-0.87 -1.28,-1.56 1.96,-0.27 2.04,-1.89 0,-2.22 -1.29,-0.41 -2.33,-1.72 -3.72,-1.75 z m -74.47,3.91 c -0.16,0.01 -0.34,-0.01 -0.5,0.03 -2,0.04 -3.66,1.56 -3.53,3.66 0.2,1.29 -0.95,1.78 -2.03,1.72 -2.04,0.94 0.88,3.31 1.88,1.56 1.05,-0.58 2.29,0.1 2.88,0.97 1.39,-0.26 1.89,-2.17 2.94,-3 0.69,-0.84 -0.11,-1.77 0.03,-2.63 -0.98,-0.36 0.05,-2.45 -1.66,-2.31 z m 87.34,9.19 c -1.36,0.43 0.14,2.64 -1.41,2.88 -1.05,-0.26 -2.43,0.16 -2.5,1.44 -0.12,1.75 2.05,2.85 3.56,2.72 1.04,-0.3 0.94,-1.66 1.59,-2.34 0.17,-1.34 0.86,-2.98 0.03,-4.19 -0.35,-0.27 -0.82,-0.56 -1.28,-0.5 z m -22.03,28.5 c -0.09,-0.01 -0.19,0.01 -0.28,0.03 -1.8,0.81 -3.86,1.37 -5.03,3.09 -0.5,0.3 -1.17,0.38 -1.34,1.06 -1.12,0.82 -2.87,1.35 -3,2.97 -0.37,0.83 -1.53,0.75 -1.66,1.81 -0.59,0.81 -0.14,1.93 0.94,1.66 0.68,0.29 1.29,1.13 2.09,0.34 1.88,-0.75 4.49,-1.94 4.19,-4.38 -0.08,-1.15 0.94,-0.2 1.31,0.09 1.36,-0.05 1.66,-1.92 2.31,-2.84 0.35,-1.12 1.66,-2.63 0.72,-3.75 -0.08,-0.05 -0.16,-0.09 -0.25,-0.09 z m 21.81,4.28 c -0.89,0.45 -1.56,1.24 -2.69,1.13 -1.15,0.21 0.37,2.44 -0.97,1.88 -0.76,-1.07 -1.95,-0 -1.28,1.03 0.07,1.52 1.86,1.91 2.31,3.06 -0.49,0.99 -1.9,-0.19 -2.31,-0.75 -1.62,-1.46 -4.11,-1.19 -6.06,-0.84 -1.12,1.19 0.85,2.07 1.84,2.28 0.92,0.59 -0.83,1.5 -1.09,1.97 -0.6,0.92 -1.74,0.9 -2.44,1.53 -0.24,1.94 2.53,1.77 3.72,2.5 1.65,0.13 3.59,-1.19 4.84,0.44 1.5,0.72 2.82,1.86 4.25,2.56 0.87,0.82 0.3,3.45 2.16,2.69 0.94,-0.88 2.62,-0.33 3.72,-1.16 1.22,-0.41 3.39,-2.48 4.38,-0.75 0.28,1.45 -1.23,2.94 -2.44,3.44 -1.39,0.68 -2.15,2.61 -4,2.03 -2.02,-0.82 -2.79,0.96 -3.41,2.5 -0.37,2.64 -3.8,3.11 -4.5,5.53 -0.1,1.7 1.8,2.09 3,1.31 1.95,-0.62 4.3,-0.15 5.66,-2 0.83,-0.45 1.84,-0.41 2.5,-1.25 1.17,-0.31 3.5,-0.65 4,0.78 -0.27,0.72 -1.67,0.72 -1.88,1.72 -1.21,1.8 -3.86,1.62 -5.44,3.06 -2.92,1.17 -6.13,1.19 -9.16,1.69 -0.83,0.35 -0.28,1.86 -1.53,1.5 -1.04,-0.11 -2.72,0.01 -3.41,-0.75 0.5,-1.1 -0.5,-1.89 -1.56,-1.75 -1.75,-1.44 -3.47,1.35 -2.69,2.97 0.43,0.9 1.93,0.31 1.13,1.72 -0.09,1.29 1.68,1.01 1.88,2.19 1.32,0.99 3.52,0.42 4.13,-1.09 2.82,-1.13 6.17,0.09 8.97,-1.28 1.47,-0.22 3.25,-0.87 4.47,0.16 2.54,0.01 3.51,-4.08 6.28,-3 2.84,0.4 3.01,-4.31 5.94,-3.84 1.2,-0.34 2.54,0.65 1.75,1.84 -0.8,0.55 -2.41,2.75 -0.59,2.84 2.64,-0.43 4.79,-2.23 7.13,-3.28 0.68,-1.4 2.54,-1.76 3,-3.22 -0.06,-1.74 -1.99,-0.52 -2.69,0.09 -0.96,0.37 -2.51,1.54 -3.44,0.78 -0.03,-1.23 1.94,-1.16 2.09,-2.47 0.05,-1.07 1.12,-0.8 1.66,-1.31 0.34,-0.77 -1.54,-1.53 -0.13,-1.94 1.14,-0.28 2.64,-0.11 3.03,-1.56 0.91,-1.46 0.99,-3.98 -1,-4.53 -0.6,-0.84 -1.42,-1.38 -2.5,-1.44 -1.7,-0.6 -2.3,-2.52 -3.63,-3.44 -0.98,0.06 -2.16,1.35 -2.91,0 -2.27,-1.75 -5.76,0.48 -7.94,-1.44 -1.11,-1.34 -0.73,-3.3 -1.88,-4.69 -0.2,-0.98 -0.6,-1.79 -1.41,-2.38 -0.71,-1.24 -1.5,-2.76 -3.09,-2.84 -1.52,-0.49 0.27,-2.6 -1.38,-2.81 -1.58,-0.05 -2.82,-1.5 -4.41,-1.41 z m -45.06,12.5 c -1.74,0.16 -2.7,2.5 -4.47,2.28 -1.09,-0.68 -2.71,-1.09 -3.94,-0.59 -0.45,0.66 -1.66,0.28 -1.81,1.31 -0.22,1.74 -0.14,3.7 0.59,5.31 0.61,0.55 1.63,0.49 1.91,1.47 0.42,1.15 2.29,1.31 2.38,-0.13 0.28,-1.1 -0.66,-2.36 0.5,-3.19 0.81,-1.13 2.31,-1.87 3.63,-1.16 1.31,0.45 2.72,-1.8 1.31,-2.41 -0.14,-1.04 1.94,-1.8 0.72,-2.75 -0.24,-0.17 -0.53,-0.18 -0.81,-0.16 z m 118.03,16.72 c 1.4,0.29 0.33,2.39 -0.22,3.06 -1.41,2.07 -3.98,2.86 -6.09,3.94 -2.25,1 -4.68,2.79 -4.78,5.44 -0.66,2.05 -3.5,2.41 -3.63,4.75 -1.58,3.85 -5.52,6 -9.19,7.47 -1.26,0.42 -0.76,-1.2 0.06,-1.41 1.62,-1.16 3.49,-1.95 4.81,-3.59 1.73,-1.34 2.88,-3.2 3.22,-5.34 0.22,-1.49 2.05,-1.29 2.28,-2.78 0.6,-2.89 3.04,-5.2 5.75,-6.13 2.38,-0.38 4.34,-2.34 5.09,-4.53 0.91,-0.2 1.79,-0.72 2.69,-0.88 z M 386.5,519.41 c 1.38,0.89 1.15,3.16 1.5,4.66 0.2,2.51 0.05,5.16 1.5,7.34 0.78,2.67 2.62,4.82 4.91,6.31 0.74,1.61 2.12,2.87 3.5,3.88 0.98,1.29 0.39,3.64 -1.5,3.47 -1.78,0.22 -3.27,2.08 -2.06,3.75 0.55,0.95 -0.32,1.34 -1,0.81 -1.13,-0.87 -3.12,-1.71 -3.16,-3.31 0.93,-5.2 -1.08,-10.37 -2.81,-15.19 -0.97,-1.58 -1.43,-3.22 -1.03,-5.06 -0.23,-2.15 -1.04,-4.69 0.16,-6.66 z m -68,15.06 c -1.48,0.86 -2.61,2.19 -4.06,3.03 -0.9,1.26 -2.64,1.74 -3.34,3.13 -3.37,1.96 -6.62,4.39 -9.16,7.34 -0.17,0.67 -0.04,1.24 -0.78,1.66 -0.94,1.11 -2.53,3.53 -0.41,4.34 1.05,0.38 3.17,1.61 3.69,0.09 1.24,-1.39 3.38,-0.28 4.44,-1.91 0.82,-0.3 0.28,1.75 1.28,1.81 1.82,-0.5 1.41,-3.2 2.41,-4.53 2.36,-2.67 3.65,-6.15 5.56,-9.16 1.08,-1.56 1.76,-3.79 0.94,-5.63 -0.13,-0.2 -0.35,-0.22 -0.56,-0.19 z m -32.25,4.94 c -2.53,0.23 -3.82,2.78 -3.47,5.13 -0.65,2.05 3.48,2.55 3.34,0.56 -0.9,-0.97 -0.16,-1.88 0.59,-2.66 0.99,-0.98 1.75,-3.19 -0.47,-3.03 z m 22.63,14.69 c -2.15,0.75 -3.94,2.55 -6.41,2.31 -2.52,0.48 -5.91,0.38 -7.06,3.22 -0.5,1.25 -1.44,2.26 -2.03,3.34 0.04,3.09 -0.46,6.81 1.66,9.34 1.61,1.02 3.69,1.53 5.56,1.56 2.29,-1.74 1.29,-5.19 2.53,-7.53 0.37,-1.4 2.37,-1.11 2.66,-2.63 1.36,-1.41 1.76,-3.34 2.88,-4.88 -0.24,-1.63 1.68,-3.01 0.97,-4.53 -0.2,-0.2 -0.48,-0.27 -0.75,-0.22 z m -19.81,4.63 c -0.96,0.38 -1.71,1.06 -2.75,1.25 -1.69,1.29 -3.4,2.61 -4.94,4.06 -0.61,1.39 -2.64,1.33 -2.94,3.03 -0.83,1.23 -0.09,3.28 -1.03,4.25 -1.79,0.88 -2.01,-2 -1.53,-3.06 0.29,-0.93 0.72,-3.6 -1,-3 -1.5,1.19 -2.98,3.07 -5.16,2.47 -1.67,0.85 -0.43,3.36 -1.16,4.84 -0.29,0.88 -2.49,1.68 -0.75,2.22 1.68,0.01 0.16,2.17 0.47,3.06 0.25,2.19 -3.57,3.23 -1.91,5.44 -0.63,1.12 -2.34,3.12 -0.56,4.06 2.49,-0.31 4.13,-2.78 5.81,-4.44 2.22,-1.96 2.43,-5.03 3.88,-7.41 1.75,-1.34 4.28,-0.22 6.31,-0.19 1.13,1.12 -0.15,2.75 -1.5,2.97 -1.23,1.03 -3.15,2.06 -3.34,3.78 0.48,0.99 2.01,0.58 2.5,1.72 1.25,1.74 2.81,3.93 2.41,6.16 -0.79,1.33 -2.79,0.6 -3.47,2.16 -1.06,1.62 -2.11,4.78 0.41,5.66 1.03,0.9 2.37,0.6 2.88,-0.66 0.84,-0.2 1.33,-0.76 1.53,-1.59 1.29,-0.84 0.38,-3.42 2.44,-3.22 3.23,1.11 6.94,-0.62 8.53,-3.59 1.36,-0.59 3.01,-1.96 2.13,-3.63 -0.24,-1.4 0.35,-3 -0.63,-4.19 -0.54,-1.57 0.03,-3.71 -1.81,-4.59 -2.45,-2.43 -1.85,-6.05 -2.47,-9.13 -0.22,-1.92 -2.17,-3.53 -1.13,-5.53 0.42,-1.25 0.8,-3.2 -1.22,-2.91 z m 58.91,24.22 c -1.19,0.17 -0.07,2.21 -1.5,1.75 -1.69,-0.05 -1.77,2.18 -3.34,2.53 -2.38,1.29 -2.12,4.5 -2.78,6.75 -0.35,3.14 4.02,4.92 3.16,8.19 -0.25,1.95 -0.63,4.22 0.97,5.69 0.37,1.45 0.3,3.15 1.78,4.06 1.39,1.08 2.85,1.99 4.47,2.69 1.86,0.69 3.85,0.43 5.53,-0.5 1.54,-0.1 4.3,0.32 4.25,-2 -0.38,-1.7 -0.6,-3.42 -0.69,-5.16 -0.6,-1.12 -3.04,-1.79 -1.88,-3.38 0.6,-1.02 3.2,-1.8 1.41,-2.94 -0.89,-1.44 -2.91,-1.06 -3.78,-2.31 0.45,-1.49 2.51,-2.72 1.69,-4.56 -0.76,-4.96 -4.18,-9.81 -9.28,-10.81 z"
					}
				}
			}
		}
	);
})(jQuery);